import java.net.ServerSocket;
import java.net.Socket;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public abstract class Listener implements Runnable {
	public Listener() { _port=-1; _isConnected=false; }
	public Listener(int port) { this(); setPort(port); }
	public Listener(String host, int port) { this(); setHostPort(host, port); }

	public void setPort(int port) {
		_isServer=true;
		_port=port;
		startThread();
	}

	public void setHostPort(String host, int port) {
		_isServer=false;
		_host=host;
		_port=port;
		startThread();
	}

	public void startThread() {
		destroy=false;
		_listenerThread=new Thread(this);
		_listenerThread.start();
	}

	public void run() {
		if (_port >= 0) {
			if (_isServer)
				runServer();
			else
				runConnect();
		} else {
			System.out.println("can't start Listener without [host],port");
		}
	}

	public void kill() {
		destroy=true;
		_isConnected=false;
		if(_listenerThread!=null)
			_listenerThread.interrupt();
		close();
	}

	void frameTimer() {
		_frametimer_numframes++;
		if (System.currentTimeMillis()-_frametimer_timer>1000) {
			System.out.println("updated at "+_frametimer_numframes+"hz");
			_frametimer_numframes=0;
			_frametimer_timer=System.currentTimeMillis();
		}
	}

	double readDouble(InputStream in) throws IOException {
		return Double.longBitsToDouble(readLong(in));
	}

	void writeDouble(OutputStream out, double x) throws IOException {
		writeLong(out,Double.doubleToLongBits(x));
	}

	long readLong(InputStream in) throws IOException {
		int read=0;
		int last=0;
		byte[] buf=new byte[8];
		while (read<8 && last>=0) { last=in.read(buf,read,8-read); read+=last; }
		if(last<0)
			_isConnected=false;
		return (b2l(buf[7])<<56) | (b2l(buf[6])<<48) |
					 (b2l(buf[5])<<40) | (b2l(buf[4])<<32) |
					 (b2l(buf[3])<<24) | (b2l(buf[2])<<16) |
					 (b2l(buf[1])<< 8) | b2l(buf[0]);
	}

	void writeLong(OutputStream out, long x) throws IOException {
		int bytelen=8;
		byte[] buf=new byte[bytelen];
		for(int i=0; i<bytelen; i++)
			buf[i]=(new Long((x>>(8*i)) & 0xff)).byteValue();
		out.write(buf,0,bytelen);
	}

	float readFloat(InputStream in) throws IOException {
		return Float.intBitsToFloat(readInt(in));
	}
	
	void writeFloat(OutputStream out, float x) throws IOException {
		writeInt(out,Float.floatToIntBits(x));
	}

	int readInt(InputStream in) throws IOException {
		int read=0;
		int last=0;
		byte[] buf=new byte[4];
		while (read<4 && last>=0) { last=in.read(buf,read,4-read); read+=last; }
		if(last<0)
			_isConnected=false;
		return (b2i(buf[3])<<24) | (b2i(buf[2])<<16) |
					 (b2i(buf[1])<< 8) | b2i(buf[0]);
	}
	
	void writeInt(OutputStream out, int x) throws IOException {
		int bytelen=4;
		byte[] buf=new byte[bytelen];
		for(int i=0; i<bytelen; i++)
			buf[i]=(new Integer((x>>(8*i)) & 0xff)).byteValue();
		out.write(buf,0,bytelen);
	}

  byte[] readBytes(InputStream in, int bytes) throws IOException {
    byte[] ret=new byte[bytes];
    readBytes(ret, in, bytes);
    return ret;
  }

	void readBytes(byte[] buf, InputStream in, int bytes) throws IOException {
		int read=0;
		int last=0;
		while (read<bytes && last>=0) {
			last=in.read(buf, read, bytes-read);
			read+=last;
		}
		if(last<0)
			_isConnected=false;
	}

	String readLine(InputStream in) throws java.io.IOException{
		StringBuffer sbuf=new StringBuffer();
		int x=in.read();
		if(x==-1) {
			_isConnected=false;
			return sbuf.toString();
		}
		char c=(char)x;
		while(c!='\n') {
			sbuf.append(c);
			x=in.read();
			if(x==-1) {
				_isConnected=false;
				return sbuf.toString();
			}
			c=(char)x;
		}
		return sbuf.toString();
	}
	
	int b2i(byte b) { return (b>=0)?(int)b:((int)b)+256; }
	long b2l(byte b) { return (b>=0)?(long)b:((long)b)+256; }

	abstract void runServer();
	abstract void runConnect();
	abstract public void close();

	boolean _isServer;
	int _port;
	String _host;
	boolean _isConnected;
	volatile Thread _listenerThread;
	volatile boolean destroy=false;

	int _frametimer_numframes=0;
	long _frametimer_timer=System.currentTimeMillis();

  public static final int PACKET_TEXT=0;
  public static final int PACKET_VISIONRAW_HALF=1;
  public static final int PACKET_VISIONRAW_FULL=2;
  public static final int PACKET_VISIONRAW_YFULL_UVHALF=3;
  public static final int PACKET_VISIONRLE_FULL=4;
  public static final int PACKET_WORLDSTATEJOINTS=5;
  public static final int PACKET_WORLDSTATEPIDS=6;
  public static final int PACKET_WORLDSTATEBUTTONS=7;
  public static final int PACKET_WMCLASS=8;
}
