import java.awt.image.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.*;
import java.awt.geom.*;
import java.io.*;

public class ImageData extends Frame {
  Toolkit toolkit;
  public int[] retdata;
  public int[] data;

  public float[] RG;
  public float[] HS;
  public float[] HB;
  public float[] SB;

  public int image_width;
  public int image_height;

  public int[] getRGB() {
    return retdata;
  }

  public float[] getRG() {
    if (RG==null) {
      RG=new float[retdata.length*2];
      for (int i=0; i<retdata.length; i++) {
        float r=(float)((retdata[i]>>16)&0xFF);
        float g=(float)((retdata[i]>>8)&0xFF);
        float b=(float)(retdata[i]&0xFF);
        RG[i*2]=r/(r+g+b);
        RG[i*2+1]=g/(r+g+b);
      }
    }
    return RG;
  }

  public float[] getHS() {
    if (HS==null) {
      HS=new float[retdata.length*2];
      float[] hsb=new float[3];
      for (int i=0; i<retdata.length; i++) {
        int r=(retdata[i]>>16)&0xFF;
        int g=(retdata[i]>>8)&0xFF;
        int b=retdata[i]&0xFF;
        Color.RGBtoHSB(r, g, b, hsb);
        HS[i*2]=hsb[0];
        HS[i*2+1]=hsb[1];
      }
    }
    return HS;
  }

  public float[] getHB() {
    if (HB==null) {
      HB=new float[retdata.length*2];
      float[] hsb=new float[3];
      for (int i=0; i<retdata.length; i++) {
        int r=(retdata[i]>>16)&0xFF;
        int g=(retdata[i]>>8)&0xFF;
        int b=retdata[i]&0xFF;
        Color.RGBtoHSB(r, g, b, hsb);
        HB[i*2]=hsb[0];
        HB[i*2+1]=hsb[2];
      }
    }
    return HB;
  }

  public float[] getSB() {
    if (SB==null) {
      SB=new float[retdata.length*2];
      float[] hsb=new float[3];
      for (int i=0; i<retdata.length; i++) {
        int r=(retdata[i]>>16)&0xFF;
        int g=(retdata[i]>>8)&0xFF;
        int b=retdata[i]&0xFF;
        Color.RGBtoHSB(r, g, b, hsb);
        SB[i*2]=hsb[1];
        SB[i*2+1]=hsb[2];
      }
    }
    return SB;
  }
  
  public ImageData() {
    toolkit=Toolkit.getDefaultToolkit();
  }

  void loadFile(String filename) {
    Image image=toolkit.createImage(filename);
    MediaTracker mediaTracker=new MediaTracker(this);
    mediaTracker.addImage(image, 0);
    try {
      mediaTracker.waitForID(0);
    } catch (InterruptedException e) {
      System.out.println(e);
      System.exit(1);
    }
    image_width=image.getWidth(this);
    image_height=image.getHeight(this);

    BufferedImage bi = new BufferedImage(image_width, image_height,
                                         BufferedImage.TYPE_INT_RGB);
    Graphics big = bi.createGraphics();
    big.drawImage(image,0,0,null);
    data=bi.getRGB(0,0,image_width,image_height,null,0,image_width);
  }

  public void loadYUVFile(String filename) {
    loadFile(filename);
    YUV2RGB();
    retdata=data;
  }

  public void YUV2RGB() {
    for (int i=0; i<data.length; i++) {
      int y=(int)((data[i]>>16)&0xFF);
      int u=(int)((data[i]>>8)&0xFF);
      int v=(int)(data[i]&0xFF);
      u=u*2-255;
      v=v*2-255;
      int r=y+u;
      int b=y+v;
      u=u>>1;
      v=(v>>2)-(v>>4);
      int g=y-u-v;
      if (r<0) r=0; if (g<0) g=0; if (b<0) b=0;
      if (r>255) r=255; if (g>255) g=255; if (b>255) b=255;

      data[i]= (r<<16) | (g<<8) | b;
    }
  }

  public void loadRGBFile(String filename) {
    loadFile(filename);
    retdata=data;
  }

  public void loadRGBFiles(String files[]) {
    loadFile(files[0]);
    retdata=data;
    for (int i=1; i<files.length; i++) {
      loadFile(files[i]);
      for (int j=i; j<retdata.length; j+=files.length)
        retdata[j]=data[j];
    }
  }

  public void loadYUVFiles(String files[]) {
    loadFile(files[0]);
    YUV2RGB();
    retdata=data;
    for (int i=1; i<files.length; i++) {
      loadFile(files[i]);
      YUV2RGB();
      for (int j=i; j<retdata.length; j+=files.length)
        retdata[j]=data[j];
    }
  }

  public void loadFullRGBFiles(String files[]) {
    for (int i=0; i<files.length; i++) {
      loadFile(files[i]);
      if (i==0) retdata=new int[files.length*data.length];
      for (int j=0; j<data.length; j++)
        retdata[j+(i*data.length)]=data[j];
    }
  }

  public void loadFullYUVFiles(String files[]) {
    for (int i=0; i<files.length; i++) {
      loadFile(files[i]);
      if (i==0) retdata=new int[files.length*data.length];
      YUV2RGB();
      int l=0;
      for (int j=i; j<retdata.length; j+=files.length)
        retdata[j]=data[l++];
    }
  }
}
