package org.tekkotsu.mon;

import java.io.InputStream;
import java.net.Socket;
import java.awt.Image;
import java.awt.image.IndexColorModel;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.io.*;

public class VisionRleListener extends VisionListener {
	static int width=176;
	static int height=144;
	byte[] _data=new byte[width*height];
	byte[] _outd=new byte[width*height];
	static int defPort=10012;
	static final boolean _debug=false;

	//todo: read this from the same file the dog is using
  String colorsFileName="default.col";
	BufferedImage img;
	
	public void connected(Socket socket) {
		_isConnected=true;
		fireVisionUpdate();
		try {
			InputStream in=socket.getInputStream();
			while (true) {
				int size=readInt(in);
				if(!_isConnected) break;
				size=size*3;
				readBytes(_data, in, size);
				if(!_isConnected) break;
				timestamp=new Date();
				decodeRLE(size);
				fireVisionUpdate();
			}
		} catch (Exception ex) { }

		try { socket.close(); } catch (Exception ex) { }
		_isConnected=false;
		fireVisionUpdate();
	}

	void decodeRLE(int pktSize) {
		int curx=0, cury=0;
		int dlength=pktSize;
		int dpos=0;

		synchronized (_outd) {
			for (; dlength>=3 && cury<height;) {
				byte color;
				color=_data[dpos++];
				int x=b2i(_data[dpos++]);
				int len=b2i(_data[dpos++]);
				dlength-=3;
				if (x < curx) {
					if (_debug) System.out.println("backwards x movement");
					break;
				}

				for (; curx < x; curx++)
					_outd[cury*width+curx]=0;

				if (curx+len>width) {
					if (_debug) System.out.println("run past end");
					break;
				}

				for (; len>0; len--, curx++)
					_outd [cury*width+curx]=color;
				if (curx==width) {
					cury++;
					curx=0;
				}
			}
		}
		if (cury!=height) {
			if (_debug) System.out.println("early end of data\n");
		}
	}

	public byte[] getData() {
//		frameTimer();
		synchronized (_outd) {
			updatedFlag=false;
			return _outd;
		}
	}

	public BufferedImage getImage() {
		synchronized (_outd) {
			byte[] data=getData();
			img.getRaster().setDataElements(0,0,width,height,data);
		}
		return img;
	}

  void initCMAP() {
    IndexColorModel cmodel=readColorModel(colorsFileName);
    img=new BufferedImage(width,height,BufferedImage.TYPE_BYTE_INDEXED,cmodel);
  }

  IndexColorModel readColorModel(String colorsfile) {
    int[] cmap=readColorMap(colorsfile);
    if (cmap==null || cmap.length==0) return null;
    byte[] byte_cmap=new byte[cmap.length*3];

    for (int i=0; i<cmap.length; i++) {
      byte_cmap[i*3]=(byte) ((cmap[i]>>16) & 0xff);
      byte_cmap[i*3+1]=(byte) ((cmap[i]>>8) & 0xff);
      byte_cmap[i*3+2]=(byte) (cmap[i] & 0xff);
    }
    IndexColorModel cmodel=new IndexColorModel(7, cmap.length, byte_cmap,
                                               0, false);
    return cmodel;
  }

  int[] readColorMap(String colorsfile) {
    try {
      BufferedReader reader=new BufferedReader(new FileReader(colorsfile));
      int[] v=new int[32];
      int vnum=0;
      String s=reader.readLine();
      while(s!=null) {
        if (s.length()==0 || s.charAt(0)=='#') { s=reader.readLine(); continue;
}
                                                                                
        int pos=Integer.parseInt(s.substring(0,s.indexOf(" ")));
                                                                                
        String colorstr=s.substring(s.indexOf("(")+1, s.indexOf(")")).trim();
        String[] colorarr=colorstr.split("\\s+");
                                                                                
        int color=0;
        color|=Integer.parseInt(colorarr[0])<<16;
        color|=Integer.parseInt(colorarr[1])<<8;
        color|=Integer.parseInt(colorarr[2]);
                                                                                
        v[pos]=color;
        if (pos>vnum) vnum=pos;
        s=reader.readLine();
      }
      int[] colors=new int[vnum+1];
      for (int i=0; i<=vnum; i++) {
        colors[i]=v[i];
      }
      return colors;
    } catch (Exception ex) {
      System.out.println("Error reading file "+colorsfile+": "+ex);
      return null;
    }
  }


	public VisionRleListener() { super(); initCMAP(); }
	public VisionRleListener(int port) { super(port); initCMAP(); }
	public VisionRleListener(String host, int port) { super(host,port); initCMAP(); }
}
