#include "StartupBehavior.h"

#include "Behaviors/Controls/ControlBase.h"
#include "Behaviors/Controls/BehaviorSwitchControl.h"

#include "Behaviors/Mon/ViewWMVarsBehavior.h"
#include "Behaviors/Mon/WalkControllerBehavior.h"
#include "Behaviors/Mon/HeadPointControllerBehavior.h"
#include "Behaviors/Mon/Aibo3DControllerBehavior.h"
#include "Behaviors/Mon/EStopControllerBehavior.h"
#include "Behaviors/Mon/WMMonitorBehavior.h"

ControlBase*
StartupBehavior::SetupTekkotsuMon() {
	addItem(new ControlBase("TekkotsuMon","Servers for GUIs"));
	startSubMenu();
	{ 
		addItem((new BehaviorSwitchControl<HeadPointControllerBehavior>("Head Remote Control",false)));
		addItem((new BehaviorSwitchControl<WalkControllerBehavior>("Walk Remote Control",false)));
		addItem((new BehaviorSwitchControl<ViewWMVarsBehavior>("View WMVars",false)));
		addItem((new BehaviorSwitchControl<WMMonitorBehavior>("Watchable Memory Monitor",false))->start());
		BehaviorSwitchControlBase::BehaviorGroup * aibo3D_bg = new BehaviorSwitchControlBase::BehaviorGroup();
		addItem((new BehaviorSwitchControl<Aibo3DControllerBehavior>("Aibo 3D",aibo3D_bg,false)));
		EStopControllerBehavior * ESCB=new EStopControllerBehavior(stop_id);
		addItem((new BehaviorSwitchControl<EStopControllerBehavior,Factory1Arg<EStopControllerBehavior,MotionManager::MC_ID,MotionManager::invalid_MC_ID> >("EStop Remote Control",ESCB))->start());
	}
	return endSubMenu();
}
