#include "StartupBehavior.h"

#include "Behaviors/Controls/ControlBase.h"

#include "Behaviors/Controls/BatteryCheckControl.h"
#include "Behaviors/Controls/FreeMemReportControl.h"
#include "Behaviors/Controls/ProfilerCheckControl.h"
#include "Behaviors/Controls/EventLogger.h"

ControlBase*
StartupBehavior::SetupStatusReports() {
	addItem(new ControlBase("Status Reports","Displays information about the runtime environment on the console"));
	startSubMenu();
	{ 
		addItem(new BatteryCheckControl());
		addItem(new ProfilerCheckControl());
		addItem(new EventLogger());
		FreeMemReportControl * tmp=new FreeMemReportControl();
		tmp->DoStart();
		addItem(tmp);
	}
	return endSubMenu();
}
