#include "StartupBehavior.h"

#include "Behaviors/Controls/ControlBase.h"
#include "Behaviors/Controls/BehaviorSwitchControl.h"

#include "Behaviors/Demos/AlanBehavior.h"
#include "Behaviors/Demos/ChaseBallBehavior.h"
#include "Behaviors/Demos/SimpleChaseBallBehavior.h"
#include "Behaviors/Demos/StareAtBallBehavior.h"
#include "Behaviors/Demos/FollowHeadBehavior.h"
#include "Behaviors/Demos/WalkToTargetMachine.h"
#include "Behaviors/Demos/BanditMachine.h"
#include "Behaviors/Demos/WorldModel2Behavior.h"
#include "Behaviors/Demos/SoundTestBehavior.h"
#include "Behaviors/Demos/ExploreMachine.h"

ControlBase*
StartupBehavior::SetupModeSwitch() {
	addItem(new ControlBase("Mode Switch","Contains the \"major\" applications - mutually exclusive selection"));
	startSubMenu();
	{
		//this group allows the behaviors to turn each other off when you start a new one so
		//only one is running at a time - like radio buttons
		BehaviorSwitchControlBase::BehaviorGroup * bg = new BehaviorSwitchControlBase::BehaviorGroup();

		//put behaviors here:
		addItem(new BehaviorSwitchControl<AlanBehavior>("AlanBehavior",bg,false));
		addItem(new BehaviorSwitchControl<FollowHeadBehavior>("FollowHeadBehavior",bg,false));
		addItem(new BehaviorSwitchControl<SoundTestBehavior>("SoundTestBehavior",bg,false));
		addItem(new BehaviorSwitchControl<ChaseBallBehavior>("ChaseBallBehavior",bg,false));
		addItem(new BehaviorSwitchControl<SimpleChaseBallBehavior>("SimpleChaseBallBehavior",bg,false));
		addItem(new BehaviorSwitchControl<StareAtBallBehavior>("StareAtBallBehavior",bg,false));
		addItem(new BehaviorSwitchControl<WalkToTargetMachine,Factory1Arg<WalkToTargetMachine,VisionEventNS::VisionSourceID_t,VisionEventNS::PinkBallSID> >("WalkToPinkBall",bg,false));
		addItem(new BehaviorSwitchControl<BanditMachine>("BanditMachine",bg,false));
		addItem(new BehaviorSwitchControl<WorldModel2Behavior>("WorldModel2Behavior",bg,false));
		addItem(new BehaviorSwitchControl<ExploreMachine>("ExploreMachine",bg,false));
	}
	return endSubMenu();
}

