//-*-c++-*-
#ifndef INCLUDED_string_util_h
#define INCLUDED_string_util_h

#include <string>
#include <vector>

namespace string_util {
	//! returns lower case version of @a s
	std::string makeLower(const std::string& s);

	//! returns @a str with @a pre removed - if @a pre is not fully matched, @a str is returned unchanged
	std::string removePrefix(const std::string& str, const std::string& pre);
	
	//! parses the input string into an arg list, with corresponding offsets of each arg in the original input
	bool parseArgs(const std::string& input, std::vector<std::string>& args, std::vector<unsigned int>& offsets); 
};

/*! @file
 * @brief Describes some useful functions for string manipulation in the string_util namespace
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_5 $
 * $Revision: 1.1 $
 * $State: Rel $
 * $Date: 2003/08/06 22:50:49 $
 */

#endif
