#include "WorldState.h"
#include "WorldStateSerializer.h"
#include "Shared/Config.h"
#include "Shared/get_time.h"
#include <string.h>
#include "RobotInfo.h"

WorldStateSerializer::WorldStateSerializer() : wsJoints(NULL), wsPIDs(NULL) {
  wsJoints=wireless->socket(SocketNS::SOCK_STREAM, 1024, 2048);
  wireless->setDaemon(wsJoints);
  wireless->listen(wsJoints, config->main.wsjoints_port);
  wsPIDs=wireless->socket(SocketNS::SOCK_STREAM, 1024, 2048);
  wireless->setDaemon(wsPIDs);
  wireless->listen(wsPIDs, config->main.wspids_port);
}

void
WorldStateSerializer::serialize() {
  char *buf=(char*)wsPIDs->getWriteBuffer((NumPIDJoints*3+1)*4);
  if (buf) {
    encode(&buf,state->lastSensorUpdateTime);
    encode(&buf,(char*)state->pids,NumPIDJoints*3*4);
    wsPIDs->write((NumPIDJoints*3+1)*4);
  }
  
  buf=(char*)wsJoints->getWriteBuffer((NumPIDJoints*2+15)*4);
  if (buf) {
    encode(&buf,state->lastSensorUpdateTime);
    encode(&buf,(char*)&state->outputs[PIDJointOffset], NumPIDJoints*4);
    encode(&buf,(char*)state->sensors,6*4);
    encode(&buf,(char*)state->buttons,8*4);
    encode(&buf,(char*)state->pidduties,NumPIDJoints*4);
    wsJoints->write((NumPIDJoints*2+15)*4);
  }
}
