#ifndef INCLUDED_Serializer_h
#define INCLUDED_Serializer_h

#include "Shared/get_time.h"
#include <iostream>

namespace SerializerNS {
  // SYNC with Listener.java in TekkotsuMon
  enum PacketFormat_t {
    packet_text=0,
    packet_visionraw_half,
    packet_visionraw_full,
    packet_visionraw_yfull_uvhalf,
    packet_visionrle_full,
    packet_worldstatejoints,
    packet_worldstatepids,
    packet_worldstatebuttons,
    packet_wmclass
  };
};

using namespace SerializerNS;

//!provides a default serializer base class for simple objects
class Serializer {
public:
	//! writes @a value to @a dst and advances @a dst
  template<class T>
  inline static void encode(char **dst, T value) {
    memcpy(*dst, (char *)&value, sizeof(T));
//    hostToNetwork(*dst, (char *)&value, sizeof(T));
//    it'd be nice to use network byte order, but we'll save the aibo
//    extra work
    (*dst) += sizeof(T);
  }

	//! converts to network byte order (big endian - aibo is little endian)
  inline static void hostToNetwork(char *dst, const char *src, int length) {
    for (int i=0; i<length; i++)
      dst[length-1-i]=src[i];
  }

	//! writes @a length bytes from @a src to @a dst
  inline static void encode(char **dst, const char *src, int length) {
    memcpy(*dst, src, length);
    (*dst) +=length;
  }

  //! writes packet type and timestamp
  inline static void encodeHeader(char **dst, PacketFormat_t pformat) {
    int time=get_time();
    encode(dst, pformat);
    encode(dst, time);
  }

	//! a simple form of compression - calls encode(@a dst,float(@a src[i])) for i=0..@a length
  inline static void encodeDoublesAsFloats(char **dst, const double *src, int length) {
    for (int i=0; i<length; i++)
      encode(dst, float(src[i]));
  }
};

/*! @file
 * @brief Defines the Serializer base class, which provides a default serializer for simple objects
 * @author alokl (Creator)
 *
 * $Author: alokl $
 * $Name: tekkotsu-1_5 $
 * $Revision: 1.5 $
 * $State: Rel $
 * $Date: 2003/07/28 06:43:52 $
 */

#endif
