//-*-c++-*-
#ifndef INCLUDED_ProcessID_h_
#define INCLUDED_ProcessID_h_

//! this is a class instead of a namespace so i can limit write access of the ID value to the OObjects
class ProcessID {
public:
	//! Holds ID number for each process
	enum ProcessID_t {
		MainProcess,   //!< MainObj process
		MotionProcess, //!< MotoObj process
		SoundProcess,  //!< SoundPlay process
		NumProcesses   //!< count of processes
	};
	
	static ProcessID_t getID() { return ID; }  //!< returns process's ID number, or if within a virtual function on a shared object, the process which created it (annoying)
	
private:
	friend class MMCombo; //!< so that it can set the ID during init
	friend class SoundPlay; //!< so that it can set the ID during init
	static void setID(ProcessID_t id) { ID=id; } //!< sets the ID during init
	static ProcessID_t ID; //!< holds ID number
};

/*! @file
 * @brief Defines ProcessID - simple little global for checking which process is currently running, kind of. (see ProcessID::getID() )
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_5 $
 * $Revision: 1.3 $
 * $State: Rel $
 * $Date: 2003/09/25 15:31:53 $
 */

#endif
