#include <Shared/Config.h>
#include <Vision/Vision.h>

namespace DynamicConfig {
  int assignVarFromController(const char *str) {
    char buf[80];
    strncpy(buf, str, 79);
    char *value=index(buf, '=');
    char *key=index(buf, '.');
    if (key==NULL || value==NULL) return -1;
    if (key>=value) return -1;
    *key=0;
    key++;
    *value=0;
    value++;
    Config::section_t section=config->parseSection(buf);
    if (section==Config::sec_invalid) return -2;
    void *val_set=config->setValue(section, key, value, true);

    if (val_set == &config->vision.white_balance ||
        val_set == &config->vision.gain ||
        val_set == &config->vision.shutter_speed)
      vision->setCameraParams();
    else if (val_set == &config->vision.resolution)
      vision->setResolution();
    else if (val_set == &config->vision.thresh ||
             val_set == &config->vision.colors)
      vision->setColors();
    
    return 0;
  }
}
