#include <Shared/Config.h>
#include <Shared/Serializer.h>
#include <stdio.h>
#include <string>
#include <ctype.h>

Config* config=NULL;
using namespace SerializerNS;

void* Config::setValue(section_t section, const char *key, const char *value,
											 bool /*updated*/) {
  switch (section) {
    case sec_wireless:
      if (strncasecmp(key,"id",29)==0) {
        wireless.id=atoi(value);
        return &wireless.id;
      }
      break;
    case sec_vision:
      if (strncasecmp(key,"white_balance",29)==0) {
        if (strncasecmp(value,"indoor",49)==0) {
          vision.white_balance=1;
        } else if (strncasecmp(value,"flourescent",49)==0) {
          vision.white_balance=3;
        } else if (strncasecmp(value,"outdoor",49)==0) {
          vision.white_balance=2;
        }
        return &vision.white_balance;
      } else if (strncasecmp(key,"gain",29)==0) {
        if (strncasecmp(value,"low",49)==0) {
          vision.gain=1;
        } else if (strncasecmp(value,"mid",49)==0) {
          vision.gain=2;
        } else if (strncasecmp(value,"high",49)==0) {
          vision.gain=3;
        }
        return &vision.gain;
      } else if (strncasecmp(key,"shutter_speed",29)==0) {
        if (strncasecmp(value,"slow",49)==0) {
          vision.shutter_speed=1;
        } else if (strncasecmp(value,"mid",49)==0) {
          vision.shutter_speed=2;
        } else if (strncasecmp(value,"fast",49)==0) {
          vision.shutter_speed=3;
        }
        return &vision.shutter_speed;
      } else if (strncasecmp(key,"resolution",29)==0) {
        if (strncasecmp(value,"full",49)==0) {
          vision.resolution=1;
        } else if (strncasecmp(value,"half",49)==0) {
          vision.resolution=2;
        } else if (strncasecmp(value,"quarter",49)==0) {
          vision.resolution=3;
        }
        return &vision.resolution;
      } else if (strncasecmp(key,"thresh",29)==0) {
        strncpy(vision.thresh,value,49);
        return &vision.thresh;
      } else if (strncasecmp(key,"colors",29)==0) {
        strncpy(vision.colors,value,49);
        return &vision.colors;
      } else if (strncasecmp(key,"raw_port",29)==0) {
        vision.raw_port=atoi(value);
        return &vision.raw_port;
      } else if (strncasecmp(key,"rle_port",29)==0) {
        vision.rle_port=atoi(value);
        return &vision.rle_port;
      } else if (strncasecmp(key,"obj_port",29)==0) {
        vision.obj_port=atoi(value);
        return &vision.obj_port;
      } else if (strncasecmp(key,"raw_encoding",29)==0) {
        if (strncasecmp(value,"half",49)==0) {
          vision.raw_encoding=packet_visionraw_half;
        } else if (strncasecmp(value,"full",49)==0) {
          vision.raw_encoding=packet_visionraw_full;
        } else if (strncasecmp(value,"yfull_uvhalf",49)==0) {
          vision.raw_encoding=packet_visionraw_yfull_uvhalf;
        }
        return &vision.raw_encoding;
      }
      break;
    case sec_main:
      if (strncasecmp(key,"console_port",29)==0) {
        main.console_port=atoi(value);
        return &main.console_port;
      } else if (strncasecmp(key,"stderr_port",29)==0) {
        main.stderr_port=atoi(value);
        return &main.stderr_port;
      } else if (strncasecmp(key,"error_level",29)==0) {
        main.error_level=atoi(value);
        return &main.error_level;
      } else if (strncasecmp(key,"debug_level",29)==0) {
        main.debug_level=atoi(value);
        return &main.debug_level;
      } else if (strncasecmp(key,"verbose_level",29)==0) {
        main.verbose_level=atoi(value);
        return &main.verbose_level;
      } else if (strncasecmp(key,"wsjoints_port",29)==0) {
        main.wsjoints_port=atoi(value);
        return &main.wsjoints_port;
      } else if (strncasecmp(key,"wspids_port",29)==0) {
        main.wspids_port=atoi(value);
        return &main.wspids_port;
      } else if (strncasecmp(key,"headControl_port",29)==0) {
        main.headControl_port=atoi(value);
        return &main.headControl_port;
      } else if (strncasecmp(key,"walkControl_port",29)==0) {
        main.walkControl_port=atoi(value);
        return &main.walkControl_port;
      } else if (strncasecmp(key,"estopControl_port",29)==0) {
        main.estopControl_port=atoi(value);
        return &main.estopControl_port;
      } else if (strncasecmp(key,"aibo3d_port",29)==0) {
        main.aibo3d_port=atoi(value);
        return &main.aibo3d_port;
      } else if (strncasecmp(key,"wmmonitor_port",29)==0) {
        main.wmmonitor_port=atoi(value);
        return &main.wmmonitor_port;
      } else if (strncasecmp(key,"use_VT100",29)==0) {
        main.use_VT100=extractBool(value);
        return &main.use_VT100;
      }
      break;
    case sec_behaviors:
      break;
    case sec_controller:
      if (strncasecmp(key,"gui_port",29)==0) {
        controller.gui_port = atoi(value);
        return &controller.gui_port ;
      } else if (strncasecmp(key,"select_snd",29)==0) {
        strncpy(controller.select_snd,value,49);
        return &controller.select_snd;
      } else if (strncasecmp(key,"next_snd",29)==0) {
        strncpy(controller.next_snd,value,49);
        return &controller.next_snd;
      } else if (strncasecmp(key,"prev_snd",29)==0) {
        strncpy(controller.prev_snd,value,49);
        return &controller.prev_snd;
      } else if (strncasecmp(key,"read_snd",29)==0) {
        strncpy(controller.read_snd,value,49);
        return &controller.read_snd;
      } else if (strncasecmp(key,"cancel_snd",29)==0) {
        strncpy(controller.cancel_snd,value,49);
        return &controller.cancel_snd;
      }
      break;
    case sec_motion:
      if (strncasecmp(key,"root",29)==0) {
        motion.root=value;
        return &motion.root;
      } else if (strncasecmp(key,"estop_on_snd",29)==0) {
        strncpy(motion.estop_on_snd,value,49);
        return &motion.estop_on_snd;
      } else if (strncasecmp(key,"estop_off_snd",29)==0) {
        strncpy(motion.estop_off_snd,value,49);
        return &motion.estop_off_snd;
      } else if (strncasecmp(key,"max_head_tilt_speed",29)==0) {
					motion.max_head_tilt_speed=atof(value);
      } else if (strncasecmp(key,"max_head_pan_speed",29)==0) {
					motion.max_head_pan_speed=atof(value);
      } else if (strncasecmp(key,"max_head_roll_speed",29)==0) {
					motion.max_head_roll_speed=atof(value);
      }
      break;
    case sec_worldmodel2:
      if (strncasecmp(key,"dm_port",29)==0) {
        worldmodel2.dm_port = atoi(value);
        return &worldmodel2.dm_port ;
      } else if (strncasecmp(key,"hm_port",29)==0) {
        worldmodel2.hm_port = atoi(value);
        return &worldmodel2.hm_port ;
      } else if (strncasecmp(key,"gm_port",29)==0) {
        worldmodel2.gm_port = atoi(value);
        return &worldmodel2.gm_port ;
      } else if (strncasecmp(key,"fs_port",29)==0) {
        worldmodel2.fs_port = atoi(value);
        return &worldmodel2.fs_port ;
      }
      break;
    case sec_sound:
      if (strncasecmp(key,"root",29)==0) {
        sound.root=value;
        return &sound.root;
      } else if (strncasecmp(key,"sample_rate",29)==0) {
        sound.sample_rate = atoi(value);
        return &sound.sample_rate ;
      } else if (strncasecmp(key,"sample_bits",29)==0) {
        sound.sample_bits = atoi(value);
        return &sound.sample_bits ;
      } else if (strncasecmp(key,"preload",29)==0) {
        sound.preload.push_back(value);
        return &sound.preload ;
      }
      break;
    default:
      break;
  }
  return NULL;
}

Config::section_t Config::parseSection(const char* key) {
  if (strncasecmp(key,"wireless",29)==0) {
    return sec_wireless;
  } else if (strncasecmp(key,"vision",29)==0) {
    return sec_vision;
  } else if (strncasecmp(key,"main",29)==0) {
    return sec_main;
  } else if (strncasecmp(key,"behaviors",29)==0) {
    return sec_behaviors;
  } else if (strncasecmp(key,"controller",29)==0) {
    return sec_controller;
  } else if (strncasecmp(key,"motion",29)==0) {
    return sec_motion;
  } else if (strncasecmp(key,"worldmodel2",29)==0) {
    return sec_worldmodel2;
  } else if (strncasecmp(key,"sound",29)==0) {
    return sec_sound;
  } else {
    return sec_invalid;
  }
}

void Config::readConfig(const char* filename) {
  FILE* fp = fopen(filename, "r");
  char buf[80], key[30], value[50];
  section_t section=sec_invalid;
  if (fp==NULL) return;
  
  while (fscanf(fp,"%79[^\n]\n", buf)!=EOF) {
    if (sscanf(buf,"[%29[^]]",key)>0) {
      section=parseSection(key);
    } else if (sscanf(buf,"%29[^=]=%49s",key,value)>1) {
      setValue(section, key, value);    
    }
  }
  fclose(fp);
}

bool Config::extractBool(const char * value) {
	int i=0;
	while(isspace(value[i])) i++;
	if(strncasecmp(&value[i],"t",29)==0)
		return true;
	else if(strncasecmp(&value[i],"f",29)==0)
		return false;
	else if(strncasecmp(&value[i],"true",29)==0)
		return true;
	else if(strncasecmp(&value[i],"false",29)==0)
		return false;
	else if(strncasecmp(&value[i],"y",29)==0)
		return true;
	else if(strncasecmp(&value[i],"n",29)==0)
		return false;
	else if(strncasecmp(&value[i],"yes",29)==0)
		return true;
	else if(strncasecmp(&value[i],"no",29)==0)
		return false;
	else
		return atoi(value);
}

/*! @file
 * @brief Implements Config, which provides global access to system configuration information
 * @author alokl (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_5 $
 * $Revision: 1.17 $
 * $State: Rel $
 * $Date: 2003/09/07 22:14:19 $
 */

