#ifndef RemoteProcess_h_DEFINED
#define RemoteProcess_h_DEFINED

#include <OPENR/OObject.h>
#include <OPENR/OSubject.h>
#include <OPENR/OObserver.h>
#include "def.h"

//! Sample RemoteProcessingOPENR process
/*! RemoteProcess runs on Linux with OPEN_R_SDK installed (and the
 *  RemoteProcessingOPENR patch). RemoteProcess talks to the Aibo using
 *  OPENR messages. RemoteProcessingOPENR can receive all the OPENR system
 *  sensor streams and write to all output streams available on the Aibo.
 *
 *  In short, use this if you're falling short of processing power on the
 *  Aibo, and the data you want processed is small in size. It'll help
 *  greatly if you're comfortable with OPENR processes and message
 *  passing.
 *
 *  Please read the RemoteProcessingOPENR instructions on the main Tekkotsu
 *  page for more information.
 */

class RemoteProcess : public OObject {
public:
  //! constructor
  RemoteProcess();
  ~RemoteProcess(); //!< destructor
  void start(); //!< called when objects are connected (by DoStart). Add user code here.
  void data_received(const char *buf); //!< called when a message is received (by RPOPENR_notify). Add user code here.

  // usercode: add additional definitions here

  // support code below here:
public:
  OSubject* subject[numOfSubject]; //!< holds information for each of our subjects (data we provide)
  OObserver* observer[numOfObserver]; //!< holds information for each of the sources we're observing

  virtual OStatus DoInit   (const OSystemEvent& event); //!< first call (after constructor), set up memory
  virtual OStatus DoStart  (const OSystemEvent& event); //!< second call, ask for messages
  virtual OStatus DoStop   (const OSystemEvent& event); //!< next to last call, stop sending and receiving messages
  virtual OStatus DoDestroy(const OSystemEvent& event); //!< last call (before destructor), clean up memory here

  bool RPOPENR_isready; //!< set to true after RPOPENR_ready() was called
  bool RPOPENR_isReady() { return RPOPENR_isready; } //!< indicates whether the Aibo is ready to receive more messages
  int RPOPENR_send(char *buf, int bufsize); //!< send message to Aibo

  void RPOPENR_ready(const OReadyEvent& event) { RPOPENR_isready=true; } //!< OPENR callback for registering when the Aibo is ready for messages
  void RPOPENR_notify(const ONotifyEvent& event); //!< OPENR callback for when a message is received from the Aibo
};

/*! @file
 * @brief Describes RemoteProcess, sample RemoteProcessingOPENR process
 * @author alokl (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_5 $
 * $Revision: 1.7 $
 * $State: Rel $
 * $Date: 2003/09/25 15:27:50 $
 */

#endif
