//-*-c++-*-
#ifndef INCLUDED_VisionEvent_h
#define INCLUDED_VisionEvent_h

#include "EventBase.h"

//! contains source IDs for the objects we can recognize
namespace VisionEventNS {
	//! contains source IDs for the objects we can recognize
  enum VisionSourceID_t {
    PinkBallSID=0,//!< the plastic pink ball Aibos ship with
    RedBallSID=0, //!< a red bean bag ball
    HandSID,      //!< Optimized for Ethan's hand, a pasty white thing.
    ThumbsupSID,  //!< Recognizes when Ethan is giving a thumbs up.
    ThingSID,     //!< Other stuff
    MarkersSID    //!< never actually generated: data directly reported to WorldModel
  };
}

//! Extends EventBase to also include location in the visual field and distance (though distance is not implimented yet)
class VisionEvent : public EventBase {
 public:
	//! Constructor
  VisionEvent() : EventBase(EventBase::visionEGID,(unsigned int)-1,EventBase::statusETID,0),_cenX(0),_cenY(0),_distance(),_property(-1) {}
	//! Constructor, pass a type id and source id
  VisionEvent(EventTypeID_t tid, unsigned int sid) : EventBase(EventBase::visionEGID,sid,tid,0),_cenX(0),_cenY(0),_distance(),_property(-1) {}
	//! Constructor, pass the type id, source id, center X and center Y
  VisionEvent(EventTypeID_t tid, unsigned int sid, float cenX, float cenY) : EventBase(EventBase::visionEGID,sid,tid,0),_cenX(cenX),_cenY(cenY),_distance(),_property(-1) {}
  
  float getCenterX() const { return _cenX;} //!< returns the x coordinate
  VisionEvent& setCenterX(float cenX) { _cenX=cenX; return *this;} //!< sets the x coordinate
  
  float getCenterY() const { return _cenY;} //!< returns the y coordinate
  VisionEvent& setCenterY(float cenY) { _cenY=cenY; return *this;} //!< sets the y coordinate

  float getDistance() const { return _distance;} //!< returns the distance (not implemented)
  VisionEvent& setDistance(float dist) { _distance=dist; return *this;} //!< sets the distance

  int getProperty() const { return _property;} //!< returns the property
  VisionEvent& setProperty(int property) { _property=property; return *this;} //!< sets the property
      
	virtual unsigned int getBinSize() const {
		unsigned int used=EventBase::getBinSize();
		used+=creatorSize("EventBase::VisionEvent");
		used+=sizeof(_cenX);
		used+=sizeof(_cenY);
		used+=sizeof(_distance);
		used+=sizeof(_property);
		return used;
	}

	virtual unsigned int LoadBuffer(const char buf[], unsigned int len) {
		unsigned int origlen=len;
		unsigned int used;
		if(0==(used=EventBase::LoadBuffer(buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=checkCreator("EventBase::VisionEvent",buf,len,true))) return 0;
		len-=used; buf+=used;
		if(0==(used=decode(_cenX,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=decode(_cenY,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=decode(_distance,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=decode(_property,buf,len))) return 0;
		len-=used; buf+=used;
		return origlen-len;	
	}

	virtual unsigned int SaveBuffer(char buf[], unsigned int len) const {
		unsigned int origlen=len;
		unsigned int used;
		if(0==(used=EventBase::SaveBuffer(buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=saveCreator("EventBase::VisionEvent",buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=encode(_cenX,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=encode(_cenY,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=encode(_distance,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=encode(_property,buf,len))) return 0;
		len-=used; buf+=used;
		return origlen-len;
	}

 protected:
	float _cenX; //!< a value representing location in visual field - from -1 if on the left edge to 1 if it's on the right edge
	float _cenY; //!< a value representing location in visual field - from -1 if on the bottom edge to 1 if it's on the top edge
	float _distance; //!< distance from snout to object in millimeters.
  int _property; //!< some property, depending on the SID
};

/*! @file
 * @brief Provides information about objects recognized in the camera image
 * @author alokl (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_5 $
 * $Revision: 1.9 $
 * $State: Rel $
 * $Date: 2003/09/12 21:38:20 $
 */

#endif
