//-*-c++-*-
#ifndef INCLUDED_VisualTargetTrans_h_
#define INCLUDED_VisualTargetTrans_h_

#include "Events/EventRouter.h"
#include "Events/VisionEvent.h"
#include "Shared/debuget.h"
#include "Shared/WorldState.h"

//! causes a transition when a visual object is "close"
class VisualTargetTrans : public Transition {
public:
	//!constructor
	VisualTargetTrans(StateNode* source, StateNode* destination, VisionEventNS::VisionSourceID_t source_id)
		: Transition(source,destination), sid(source_id), count(0) {}

	//!starts listening for the object specified by the source id in the constructor
	virtual void DoStart() {
		serr->printf("VisualTargetTrans::DoStart() - enter\n");
		Transition::DoStart();
		count=0;
		erouter->addListener(this,EventBase::visionEGID,sid);
		serr->printf("VisualTargetTrans::DoStart() - leave\n");
	}

	//!called by StateNode when it becomes inactive - undo whatever you did in Enable()
	virtual void DoStop() {
		serr->printf("VisualTargetTrans::DoStop() - enter\n");
		erouter->forgetListener(this);
		count=0;
		Transition::DoStop();
		serr->printf("VisualTargetTrans::DoStop() - leave\n");
	}

	//!if the object is "close", calls activate()
	virtual void processEvent(const EventBase& e) {
		serr->printf("VisualTargetTrans::processEvent() - enter %d\n",get_time());

		if(e.getTypeID()==EventBase::deactivateETID)
			count=0;
		else
			count++;
		if(count>5)
			activate();

		serr->printf("VisualTargetTrans::processEvent() - leave %d\n",get_time());
	}

	virtual std::string getName() const { return "VisualTargetTrans"; }

protected:
	//!Source ID of object to track
	VisionEventNS::VisionSourceID_t sid;
	unsigned int count;
};

/*! @file
 * @brief Defines VisualTargetTrans, which causes a transition when a visual object is seen for a few frames
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_5 $
 * $Revision: 1.5 $
 * $State: Rel $
 * $Date: 2003/10/03 03:40:23 $
 */

#endif
