//-*-c++-*-
#ifndef INCLUDED_VisualTargetCloseTrans_h_
#define INCLUDED_VisualTargetCloseTrans_h_

#include "Events/EventRouter.h"
#include "Events/VisionEvent.h"
#include "Shared/debuget.h"
#include "Shared/WorldState.h"

//! causes a transition when a visual object is "close"
class VisualTargetCloseTrans : public Transition {
public:
	//!constructor
	VisualTargetCloseTrans(StateNode* source, StateNode* destination, VisionEventNS::VisionSourceID_t source_id) : Transition(source,destination), sid(source_id) {}

	//!starts listening for the object specified by the source id in the constructor
	virtual void DoStart() { Transition::DoStart(); erouter->addListener(this,EventBase::visionEGID,sid); }

	//!called by StateNode when it becomes inactive - undo whatever you did in Enable()
	virtual void DoStop() { erouter->forgetListener(this); Transition::DoStop(); }

	//!if the object is "close", calls activate()
	virtual void processEvent(const EventBase& e) {
		const VisionEvent* ve=dynamic_cast<const VisionEvent*>(&e);
		ASSERTRET(ve!=NULL,"Casting error");
		float x=ve->getCenterX();
		float y=ve->getCenterY();
		if(x*x+y*y<0.02f && state->sensors[IRDistOffset]<300)
			activate();
	}

	virtual std::string getName() const { return "VisualTargetCloseTrans"; }

protected:
	//!Source ID of object to track
	VisionEventNS::VisionSourceID_t sid;
};

/*! @file
 * @brief Defines VisualTargetCloseTrans, which causes a transition when a visual object is "close"
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_5 $
 * $Revision: 1.5 $
 * $State: Rel $
 * $Date: 2003/09/25 15:26:57 $
 */

#endif
