//-*-c++-*-
#ifndef INCLUDED_TimeOutTrans_h_
#define INCLUDED_TimeOutTrans_h_

#include "Behaviors/Transition.h"
#include "Events/EventRouter.h"

//! causes a transition after a specified amount of time has passed
class TimeOutTrans : public Transition {
public:
	//! constructor, specify delay in milliseconds
	TimeOutTrans(StateNode* source, StateNode* destination, unsigned int delay) : Transition(source,destination), d(delay) {}
	
	//!starts timer
	virtual void DoStart() {
		Transition::DoStart();
		resetTimer(); 
	}

	//!stops timer
	virtual void DoStop() { erouter->forgetListener(this); Transition::DoStop(); }

	//!resets timer
	void resetTimer() {
		std::cout << "Reset @ " << get_time() << " stop @ " << get_time()+d << ' ' << this << std::endl;
		erouter->addTimer(this,0,d,false);
	}

	//!if we receive the timer event, activate()
	virtual void processEvent(const EventBase& e) {
		std::cout << "Timeout @ " << get_time() << " from " << e.getName() << ' ' << this << std::endl;
		activate();
	}

	virtual std::string getName() const { return "TimeOutTrans"; }

protected:
	//!amount to delay (in milliseconds) before transition
	unsigned int d;
};

/*! @file
 * @brief Defines TimeOutTrans, which causes a transition after a specified amount of time has passed
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_5 $
 * $Revision: 1.7 $
 * $State: Rel $
 * $Date: 2003/10/03 03:40:23 $
 */

#endif
