//-*-c++-*-
#ifndef INCLUDED_Transition_h_
#define INCLUDED_Transition_h_

#include "BehaviorBase.h"

class StateNode;

//! Represents a transition between StateNodes.
/*! This is an abstract class - you'll want to subclass it to put
 *  conditions on the transitions
 *
 *  DoStart() will be called when this transition is 'active' - it should
 *  listen/monitor for the transition it represents until DoStop() is called.
 *  
 *  If the conditions are satisified for a transition, you should call activate()
 *  to do the appropriate notifications. */
class Transition : public BehaviorBase {
public:
	//!constructor, specifies source and destination StateNode's
	Transition(StateNode* source, StateNode* destination) : BehaviorBase(), src(source), dst(destination) {}
	//!copy constructor, just in case you need it
	Transition(const Transition& t) : BehaviorBase(t), src(t.src), dst(t.dst) {}
	//!destructor
	virtual ~Transition() {}

	//!call this when the transition should be made, base class version simply calls StateNode::DoStop() on #src and StateNode::DoStart() on #dst, but you can override.
	virtual void activate();

	//!assignment operator (only does shallow copy)
	Transition& operator=(const Transition& t) { BehaviorBase::operator=(t); src=t.src; dst=t.dst; return *this; }
protected:
	StateNode* src; //!< the node being transitioned from
	StateNode* dst; //!< the node being transitioned to
};

/*! @file
 * @brief Describes Transition, represents a transition between StateNodes.
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_5 $
 * $Revision: 1.2 $
 * $State: Rel $
 * $Date: 2003/08/21 22:32:41 $
 */

#endif
