#include "StateNode.h"
#include "Events/EventRouter.h"
#include "Wireless/Wireless.h"

StateNode::~StateNode() {
	//std::cout << getName() << " DESTRUCTOR!!!!!!!" << this << std::endl;
	ASSERT(!isActive(), "Destructing while active?")
	for(std::vector<Transition*>::iterator it=transitions.begin(); it!=transitions.end(); it++)
		(*it)->RemoveReference();
	if(issetup) {
		for(std::vector<StateNode*>::iterator it=nodes.begin(); it!=nodes.end(); it++)
			(*it)->RemoveReference();
	}
}

void StateNode::addTransition(Transition* trans) {
	transitions.push_back(trans);
	trans->AddReference();
}

void StateNode::DoStart() {
	BehaviorBase::DoStart();
	if(!issetup) {
		//std::cout << getName() << " setting up... " << this << std::endl;
		setup();
		issetup=true;
	}
	for(std::vector<Transition*>::iterator it=transitions.begin(); it!=transitions.end(); it++)
		(*it)->DoStart();
	erouter->postEvent(EventBase::stateMachineEGID,reinterpret_cast<unsigned int>(this),EventBase::activateETID,0,getName(),1);
	if(parent!=NULL)
		parent->transitionTo(this);
}

void StateNode::DoStop() {
	//	for(int i=0; i<500; i++)
	//cout << "BLAH " << getName() << " 0" << endl;
	//serr->printf("BLAH %s %d\n",getName().c_str(),0);
	for(std::vector<Transition*>::iterator it=transitions.begin(); it!=transitions.end(); it++) {
		ASSERT((*it)->isActive(),"Inactive transition");
		if((*it)->isActive())
			(*it)->DoStop();
	}
	//	for(int i=0; i<500; i++)
	//cout << "BLAH " << getName() << " 1" << endl;
	//serr->printf("BLAH %s %d\n",getName().c_str(),1);
	for(std::vector<StateNode*>::iterator it=nodes.begin(); it!=nodes.end(); it++)
		if((*it)->isActive())
			(*it)->DoStop();
	//for(int i=0; i<1000; i++)
	//cout << "BLAH 2" << endl;
	//serr->printf("BLAH %s %d\n",getName().c_str(),2);
	if(!retain) {
		std::cout << getName() << " unretaining... " << this << std::endl;
		for(std::vector<StateNode*>::iterator it=nodes.begin(); it!=nodes.end(); it++)
			(*it)->RemoveReference();
		teardown();
		issetup=false;
	}
	///for(int i=0; i<1000; i++)
	//cout << "BLAH 3" << endl;
	//serr->printf("BLAH %s %d\n",getName().c_str(),3);
	erouter->postEvent(EventBase::stateMachineEGID,reinterpret_cast<unsigned int>(this),EventBase::deactivateETID,0,getName(),0);
	//for(int i=0; i<1000; i++)
	//cout << "BLAH 4" << endl;
	//serr->printf("BLAH %s %d\n",getName().c_str(),4);
	BehaviorBase::DoStop();
	//for(int i=0; i<1000; i++)
	//cout << "BLAH 5" << endl;
	//serr->printf("BLAH %s %d\n",getName().c_str(),5);
}

void StateNode::setName(const std::string& n) {
	name=n;
}

void StateNode::transitionTo(StateNode*) {
	// may want to throw a status event here
}

void StateNode::transitionFrom(StateNode*) {
	// may want to throw a status event here
}

/*! @file 
 * @brief Describes StateNode, which is both a state machine controller as well as a node within a state machine itself
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_5 $
 * $Revision: 1.10 $
 * $State: Rel $
 * $Date: 2003/10/10 16:00:54 $
 */

