#ifndef INCLUDED_WorldModel2Behavior_h_
#define INCLUDED_WorldModel2Behavior_h_

/* @file
 * @brief Implements WorldModel2Behavior, a stateful behavior specifically designed to feed data to the second WorldModel.
 * Started 13 February 2003, tss
 * @author tss (Creator)
 */

#include "Behaviors/StateNode.h"
#include "Motion/MotionManager.h"
#include "WorldModel2/WorldModel2.h"
#include "Motion/MotionSequenceMC.h"
#include "Shared/SharedObject.h"

//! Implements a stateful behavior specifically designed to feed data to the second WorldModel.
class WorldModel2Behavior : public StateNode {
public:
  WorldModel2Behavior();		//!< Constructor
  virtual ~WorldModel2Behavior();	// Destructor

  virtual void setup();			//!< Initial setup
  virtual void DoStart();		//!< Behavior startup
  virtual void DoStop();		//!< Behavior stop

	static std::string getClassDescription() { return "Attempts to build and transmit a spherical depth map and horizontal height map (run MATLAB visualizer to see)"; }

private:
  StateNode *start;			//!< Pointer to the start state
  WorldModel2 WM2;			//!< WorldModel2 controller

  //! Crap related to standing up
  SharedObject< MotionSequenceMC<MotionSequence::SizeSmall> > standUp;
  MotionManager::MC_ID standUp_id; //!< id for the standup
  
  // Private classes for specific behavior states
  //! This one does a random walk
  struct WalkNode : public StateNode {
    WalkNode(const char *title, StateNode *poppa,
	     MotionManager::MC_ID su);	//!< Constructor
    virtual ~WalkNode();		//!< Destructor

    virtual void processEvent(const EventBase&);	//!< IR obstacle avoidance

    virtual void DoStart();		//!< Behavior startup
    virtual void DoStop();		//!< Behavior stop

    MotionManager::MC_ID walker_id;	//!< A motion command ID for WalkMC
    MotionManager::MC_ID head_id;	  //!< A motion command ID for the head
    MotionManager::MC_ID stand_id;	//!< A motion command ID for standing up
    enum { TURN, AHEAD } walkstate;	//!< are we walking forward or turning?

    static const double THR_TURN = 300;	//!< obstacle threshold for turning away
    static const double THR_AHEAD =600;	//!< obstacle threshild for stopping turn
  };
  //! This one wags the head around
  struct GawkNode : public StateNode {
    WorldModel2 *WM2ref;		//!< Reference to WM2B's WM2 object

    GawkNode(const char *title, StateNode *poppa,
	     WorldModel2 *WM,
             MotionManager::MC_ID su);	//!< Constructor

    virtual void processEvent(const EventBase&);	//!< Head wag poll timer

    virtual void DoStart();		//!< Behavior startup
    virtual void DoStop();		//!< Behavior stop

    MotionManager::MC_ID head_id;	  //!< A motion command ID for the head
    MotionManager::MC_ID stand_id;	//!< A motion command ID for standing up

    // to avoid warnings
    GawkNode(const WorldModel2Behavior::GawkNode&); //!< don't call
    GawkNode operator=(const WorldModel2Behavior::GawkNode&); //!< don't call
  };
  //! This one lets the AIBO have a reflective pause
  struct WaitNode : public StateNode {
    WaitNode(const char *title, StateNode *poppa,
	     MotionManager::MC_ID su);	//!< Constructor

    virtual void DoStart();		//!< Behavior startup
    virtual void DoStop();		//!< Behavior stop

    MotionManager::MC_ID head_id;	  //!< A motion command ID for the head
    MotionManager::MC_ID stand_id;	//!< A motion command ID for standing up
  };

  // to avoid warnings:
  WorldModel2Behavior(const WorldModel2Behavior&); //!< don't call
  WorldModel2Behavior operator=(const WorldModel2Behavior&); //!< don't call
};

#endif
