//-*-c++-*-
#ifndef INCLUDED_ExploreMachine_h_
#define INCLUDED_ExploreMachine_h_

#include "Behaviors/StateNode.h"
#include "Behaviors/Nodes/WalkNode.h"
#include "Behaviors/Transitions/SmoothCompareTrans.h"
#include <stdlib.h>

//! A state machine for exploring an environment (or searching for an object)
class ExploreMachine : public StateNode {
public:
	//!constructor
	ExploreMachine(StateNode* p=NULL)
		: StateNode("ExploreMachine",p), start(NULL), turn(NULL), walkid(MotionManager::invalid_MC_ID)
	{
		//setRetain(false);
	}

	virtual void setup() {
		SharedObject<WalkMC> walk;
		walkid=motman->addMotion(walk);
		WalkNode * move=NULL;
		start=addNode(turn=new WalkNode(0,0,0.5f,this));
		turn->setName(getName()+"::turn");
		addNode(move=new WalkNode(150,0,0,this));
		move->setName(getName()+"::move");
		turn->addTransition(new TimeOutTrans(turn,move,2000));
		move->addTransition(new SmoothCompareTrans<float>(move,turn,&state->sensors[IRDistOffset],CompareTrans<float>::LT,350,EventBase(EventBase::sensorEGID,SensorSourceID::UpdatedSID,EventBase::statusETID),.7));
		turn->setWalkID(walkid);
		move->setWalkID(walkid);
		StateNode::setup();
	}

	virtual void DoStart() {
		StateNode::DoStart();
		start->DoStart();
		//erouter->addListener(this,EventBase::sensorEGID,SensorSourceID::UpdatedSID);
		erouter->addListener(this,EventBase::stateMachineEGID,(unsigned int)turn);
	}

	virtual void DoStop() {
		erouter->forgetListener(this);
		StateNode::DoStop();
	}

	virtual void teardown() {
		motman->removeMotion(walkid);
		StateNode::teardown();
	}

	virtual void processEvent(const EventBase& /*e*/) {
		sout->printf("IR: %g\n",state->sensors[IRDistOffset]);
		float vel=rand()/(float)RAND_MAX*2.0f-1;
		if(vel<0)
			vel-=.25;
		if(vel>0)
			vel+=.25;
		turn->setAVelocity(vel);
	}

protected:
	StateNode * start; //!< the node to begin within on DoStart() (turn)
	WalkNode * turn; //!< walk node to use when turning
	MotionManager::MC_ID walkid; //!< we want to share a walk between turning and walking nodes

private:
	ExploreMachine(const ExploreMachine&); //!< don't use
	ExploreMachine operator=(const ExploreMachine&); //!< don't use
};

/*! @file
 * @brief Describes ExploreMachine, a state machine for exploring an environment (or searching for an object)
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_5 $
 * $Revision: 1.11 $
 * $State: Rel $
 * $Date: 2003/10/10 17:46:01 $
 */

#endif
