#include "HelpControl.h"

ControlBase * HelpControl::activate(MotionManager::MC_ID disp_id, Socket * gui) {
	char * fmt="  * ";
	if(config->main.use_VT100) {
		fmt="\33[1m  * \33[0m";
		sout->printf("%s","\33[1m* Global commands\33[0m: type these anytime, interpreted directly by Controller\n");
	} else
		sout->printf("%s","* Global commands: type these anytime, interpreted directly by Controller\n");
	sout->printf("%s%s",fmt,"'!refresh' - redisplays the current control (handy on first connecting, or when other output has scrolled it off the screen)\n");
	sout->printf("%s%s",fmt,"'!reset' - return to the root control\n");
	sout->printf("%s%s",fmt,"'!next' - calls doNextItem() of the current control\n");
	sout->printf("%s%s",fmt,"'!prev' - calls doPrevItem() of the current control\n");
	sout->printf("%s%s",fmt,"'!select' - calls doSelect() of the current control\n");
	sout->printf("%s%s",fmt,"'!cancel' - calls doCancel() of the current control\n");
	sout->printf("%s%s",fmt,"'!msg text' - broadcasts text as a TextMsgEvent\n");
	sout->printf("%s%s",fmt,"'!hilight [n1 [n2 [...]]]' - hilights zero, one, or more items in the menu\n");
	sout->printf("%s%s",fmt,"'!input text' - calls takeInput(text) on the currently hilighted control(s)\n");
	sout->printf("%s%s",fmt,"any text not beginning with ! - sent to takeInput() of the current control\n");
	report(root,"");
	return NullControl::activate(disp_id,gui);
}

//! displays the menu items of @a r and their descriptions, recursing on submenus
/*! @a prefix is what should be displayed before each menu item (like a bullet point)
 *  this is itself prefixed by 2 spaces for each level of recursion.  Word wrapping
 *  is performed to maintain the clean indenting */
void HelpControl::report(ControlBase* r, const std::string& prefix) {
	if(r==NULL)
		return;
	const std::vector<ControlBase*>& slots=r->getSlots();
	const std::string pre="  "+prefix;
	unsigned int numlen=1;
	if(slots.size()>1)
		numlen=(int)(log(slots.size()-1)/log(10))+1;
	for(unsigned int i=0; i<slots.size(); i++) {
		if(slots[i]==NULL)
			continue;
		char * fmt;
		std::string nm=slots[i]->getName();
		std::string desc=slots[i]->getDescription();
		unsigned int len=term_width-(prefix.size()+nm.size()+4+numlen);
		if((int)len<0)
			len=0;
		if(len>desc.size())
			len=desc.size();
		else
			while(len>0 && !isspace(desc[len-1])) len--;
		if(config->main.use_VT100)
			fmt="\33[1m%s%*d. %s\33[0m: %s\n";
		else
			fmt="%s%*d. %s: %s\n";
		sout->printf(fmt,prefix.c_str(),numlen,i,nm.c_str(),desc.substr(0,len).c_str());
		while(len<desc.size() && isspace(desc[len])) len++;
		desc=desc.substr(len);
		while(desc.size()>0) {
			len=term_width-prefix.size();
			if((int)len<0)
				len=0;
			if(len>desc.size())
				len=desc.size();
			else {
				while(len>0 && !isspace(desc[len-1])) len--;
				if(len==0)
					len=term_width-prefix.size();
				if(len>desc.size())
					len=desc.size();
			}
			sout->printf("%s%s\n",std::string(prefix.size(),' ').c_str(),desc.substr(0,len).c_str());
			while(len<desc.size() && isspace(desc[len])) len++;
			desc=desc.substr(len);
		}
		report(slots[i],pre);
	}
}

/*! @file
 * @brief Implements HelpControl, which recurses through the menu system and outputs the name and description of each item
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_5 $
 * $Revision: 1.4 $
 * $State: Rel $
 * $Date: 2003/09/25 15:26:11 $
 */

