//-*-c++-*-
#ifndef INCLUDED_EventLogger_h_
#define INCLUDED_EventLogger_h_

#include "ControlBase.h"
#include "Events/EventListener.h"
#include <fstream>

//! allows logging of events to the console or a file
class EventLogger : public ControlBase, public EventListener {
public:
	//!constructor
	EventLogger();

	//!opens a custom (embedded) menu to toggle individual EGIDs
	virtual ControlBase* doSelect();
	
	virtual void refresh();

	//!sends all events received to stdout and/or logfile
	virtual void processEvent(const EventBase& event);

protected:
	//!sets the status char of slot @a i to @a c
	void setStatus(unsigned int i, char c);

	//!checks to see if logfilePath differs from the StringInputControl's value and switches it if it is
	void checkLogFile();
	
	//!address of the logfile, if any (empty string is no logfile)
	std::string logfilePath;

	//!if a filename is given, events are logged to here
	std::ofstream logfile;

	//!controls the level of verbosity - currently 0 through 2
	unsigned int verbosity;
};

/*! @file
 * @brief Describes EventLogger, which allows logging of events to the console or a file
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_5 $
 * $Revision: 1.5 $
 * $State: Rel $
 * $Date: 2003/09/25 15:26:10 $
 */

#endif
