import java.awt.image.*;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

public class VisionRaw extends VisionPanel {
	VisionRawListener _visionraw;
	
	public static void main(String s[]) {
		int port=VisionRawListener.defPort;
		if(s.length<1) {
			System.out.println("Usage: java VisionRaw host [port]");
			System.out.println("			 if port is not specified, it defaults to "+port);
			System.exit(2);
		}
		if(s.length>1)
			port=Integer.parseInt(s[1]);
		JFrame frame=new JFrame("TekkotsuMon: Vision Raw");
		frame.setBackground(Color.black);
		//frame.getContentPane().setLayout(new FlowLayout());
		frame.setSize(new Dimension(VisionRawListener.width*2, VisionRawListener.height*2)); 
		VisionRaw vision=new VisionRaw(new VisionRawListener(s[0],port));
		frame.getContentPane().add(vision);
		frame.addWindowListener(new WindowAdapter() {
				public void windowClosing(WindowEvent e) { System.exit(0); } });
		frame.show();
	}

	public VisionRaw(VisionRawListener visionraw) {
		super(visionraw);
		_visionraw=visionraw;
	}

	public void setConvertRGB(boolean b) { _visionraw.setConvertRGB(b); }
	public boolean getConvertRGB(boolean b) { return _visionraw.getConvertRGB(); }
}

