import java.io.*;
import java.net.Socket;
import java.util.Vector;
import java.lang.Integer;
import java.util.HashMap;
import java.lang.Class;
import java.lang.reflect.Method;
import java.lang.reflect.Constructor;

public class ControllerListener extends TCPListener {
	boolean _updatedFlag=false;
	Vector _titles;
	Vector _menus;
	Vector _selections;
	String _status;
	PrintStream _out;
	ControllerGUI listener;
	HashMap dynObjs=new HashMap();
	InputStream sin;
	
	public class MenuEntry {
		boolean hasSubmenu;
		boolean selected;
		String title;
		String description;
		MenuEntry(boolean hasSubmenu, boolean selected, String title, String description) {
			this.hasSubmenu=hasSubmenu;
			this.selected=selected;
			this.title=title;
			this.description=description;
		}
		public String toString() { return title; }
	}
	
	static String escapize(Vector path) {
		System.out.println("Escapize:"+path);
		StringBuffer p=new StringBuffer();
		System.out.println("Escapized1:"+p);
		for(int i=0; i<path.size(); i++) {
			p.append("/");
			System.out.println("Escapized2:"+p);
			p.append(((String)path.get(i)).replaceAll("\\\\","\\\\\\\\").replaceAll("/","\\\\/"));
			System.out.println("Escapized3:"+p);
		}
		System.out.println("Escapized:"+p);
		return p.toString();
	}

	public Vector buildSelectionPath(int index) {
		Vector ans=buildSelectionPath();
		ans.add(((Vector)_menus.lastElement()).get(index).toString());
		return ans;
	}
		
	public Vector buildSelectionPath() {
		Vector ans=new Vector();
		for(int i=0; i<_menus.size()-1; i++)
			ans.add(((Vector)_menus.get(i)).get(((Integer)_selections.get(i)).intValue()).toString());
		return ans;
	}
		
	void sendSelectionPath(Vector path) {
		try {
			_out.println("!select");
		} catch (Exception ex) { }
	}
	
	void sendSelect() {
		try {
			_out.println("!select");
		} catch (Exception ex) { }
	}
	
	void sendReturn() {
		try {
			_out.println("!cancel");
		} catch (Exception ex) { }
	}
	
	void sendRefresh() {
		try {
			_out.println("!refresh");
		} catch (Exception ex) { }
	}
	
	void sendInput(String s,Vector path) {
		try {
			Vector cur=buildSelectionPath();
			sendSelectionPath(path);
			_out.println(s);
			sendSelectionPath(cur);
		} catch (Exception ex) { }
	}
	
	void sendInput(String s) {
		try {
			_out.println(s);
		} catch (Exception ex) { }
	}
	
	void sendSelection(int sel[]) {
		try {
			String msg="!hilight";
			for(int i=0; i<sel.length; i++) {
				msg+=" ";
				msg+=sel[i];
			}
			_out.println(msg);
		} catch (Exception ex) { }
	}

	void connected(Socket socket) {
		_isConnected=true;
		_menus=new Vector();
		_menus.add(new Vector());
		_titles=new Vector();
		_titles.add("Unset");
		System.out.println("connection opened");
		try {
			sin=socket.getInputStream();
			_out=new PrintStream(socket.getOutputStream());
			_out.println("!refresh");
			while (true) {
				String msgtype=readLine(sin);
				if(!_isConnected) break;
				//				System.out.println("Received: "+msgtype);
				synchronized(_menus) {
					if(msgtype.equals("push")) {
						_menus.add(new Vector());
						_titles.add("Unset");
					}
					if(msgtype.equals("refresh") || msgtype.equals("push")) {
						String last=readLine(sin);
						if(!_isConnected) break;
						_titles.set(_titles.size()-1,last);
						int len=Integer.parseInt(readLine(sin));
						if(!_isConnected) break;
						Vector menu=(Vector)_menus.lastElement();
						menu.clear();
						for(;len>0;len--) {
							int x=Integer.parseInt(readLine(sin));
							if(x==-1) {
								_isConnected=false;
								break;
							}
							int sel=Integer.parseInt(readLine(sin));
							if(x==-1) {
								_isConnected=false;
								break;
							}
							last=readLine(sin);
							if(!_isConnected) break;
							String descript=readLine(sin);
							if(!_isConnected) break;
							menu.add(new MenuEntry((x>0),(sel>0),last,descript));
						}
						_status="";
						if(!_isConnected) break;
					} else if(msgtype.equals("pop")) {
						_menus.remove(_menus.size()-1);
						_titles.remove(_titles.size()-1);
					} else if(msgtype.equals("reset")) {
						_menus.clear();
						_menus.add(new Vector());
						_titles.clear();
					} else if(msgtype.equals("status")) {
						_status=readLine(sin);
						if(!_isConnected) break;
					} else if(msgtype.equals("load")) {
						String type=readLine(sin);
						if(!_isConnected) break;
						String name=readLine(sin);
						if(!_isConnected) break;
						int port=Integer.parseInt(readLine(sin));
						if(!_isConnected) break;
						String args=readLine(sin);
						if(!_isConnected) break;
						String[] argArr=parseArgs(args);
						if(!_isConnected) break;
						Class objClass=null;
						try {
							objClass=Class.forName(type);
						} catch(Exception ex) { System.out.println("Could not load "+type+": "+ex); }
						if(objClass!=null) {
							Class[] consArgClasses=new Class[3];
							Object[] consArgs=new Object[3];
							consArgs[0]=_host;
							consArgs[1]=new Integer(port);
							consArgs[2]=argArr;
							for(int i=0;i<consArgs.length;i++)
								consArgClasses[i]=consArgs[i].getClass();
							consArgClasses[1]=Integer.TYPE;
							Constructor objCons=objClass.getConstructor(consArgClasses);
							Object obj=objCons.newInstance(consArgs);
							dynObjs.put(name,obj);
						}
					} else if(msgtype.equals("close")) {
						String name=readLine(sin);
						if(!_isConnected) break;
						Object obj=dynObjs.get(name);
						if(obj==null) {
							System.out.println("ControllerGUI: error - could not close "+name+" - not loaded");
						} else {
							Method m=obj.getClass().getMethod("close",null);
							m.invoke(obj,null);
						}
					} else {
						System.err.println("ControllerListener - Invalid message type:"+msgtype);
					}
					_updatedFlag=true;
					if(listener!=null)
						listener.repaint();
					else
						System.out.println("null listener");
				}
			}
		} catch (Exception ex) { ex.printStackTrace(System.out); }
		
		try { socket.close(); } catch (Exception ex) { }

		while(_updatedFlag)
				try { Thread.sleep(100); } catch (Exception ex) {}

		_isConnected=false;
		_updatedFlag=true;
		if(listener!=null)
			listener.repaint();
		//The sleep is to get around the socket still listening after being closed thing
		System.out.println("ControllerGUI - connection closed... reconnect after 5 seconds");
		try { Thread.sleep(5000); } catch (Exception ex) {}
	}
 
	public boolean hasData() {
		return _updatedFlag;
	}

	public boolean isConnected() {
		return _isConnected;
	}

	public String[] parseArgs(String args) throws java.io.IOException {
		Vector v=new Vector();
		StringBuffer cur=new StringBuffer();
		boolean isDoubleQuote=false;
		boolean isSingleQuote=false;
		do {
			for(int i=0; i<args.length(); i++) {
				char c=args.charAt(i);
				switch(c) {
				case ' ':
					if(isSingleQuote || isDoubleQuote)
						cur.append(c);
					else {
						v.add(cur.toString());
						cur.setLength(0);
					}
					break;
				case '\\':
					if(i==args.length()-1) { //escaped line break
						args=readLine(sin);  //get next line and continue
						if(!isConnected()) {
							if(cur.length()>0)
								v.add(cur.toString());
							return makeArray(v);
						}
						if(isSingleQuote || isDoubleQuote)
							cur.append('\n');
						i=-1;
					} else
						cur.append(args.charAt(++i));
					break;
				case '"':
					if(isSingleQuote)
						cur.append(c);
					else
						isDoubleQuote=!isDoubleQuote;
					break;
				case '\'':
					if(isDoubleQuote)
						cur.append(c);
					else
						isSingleQuote=!isSingleQuote;
					break;
				default:
					cur.append(c);
					break;
				}
			} 
		} while(isDoubleQuote || isSingleQuote);
		if(cur.length()>0)
			v.add(cur.toString());
		return makeArray(v);
	}

	protected String[] makeArray(Vector v) {
		String[] ans=new String[v.size()];
		for(int i=0; i<v.size(); i++)
			ans[i]=(String)v.get(i);
		return ans;
	}

	public ControllerListener() { super(); }
	public ControllerListener(int port) { super(port); }
	public ControllerListener(String host, int port) { super(host,port); }
}
