import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class WorldStateJointsWriter extends TCPListener {
  OutputStream _out;

  void connected(Socket socket) {
    try {
      _out=socket.getOutputStream();
    } catch (Exception ex) { return; }
    _isConnected=true;
  }

  public boolean hasData() {
    return false;
  }

  public Joints getData() {
    return null;
  }

  public void close() {
    _isConnected=false;
    super.close();
  }

  public void write(float[] f) {
    try {
      for (int i=0; i<f.length; i++)
        writeFloat(_out, f[i]);
    } catch (Exception ex) { close(); }
  }

  public boolean isConnected() {
    return _isConnected;
  }

  public WorldStateJointsWriter() { super(); }
  public WorldStateJointsWriter(int port) { super(port); }
  public WorldStateJointsWriter(String host, int port) { super(host,port); }
}
