#ifndef _POSES_H_
#define _POSES_H_

#include <math.h>

/* Standing pose joint angle tolerance */
#define SP_TOLERANCE	5*180/M_PI

/* Ideal standing pose joint angles */
#define SP_LFR_JOINT	-0.2000
#define SP_LFR_SHLDR	 0.0600
#define SP_LFR_KNEE	 0.7500
#define SP_RFR_JOINT	-0.2000
#define SP_RFR_SHLDR	 0.0600
#define SP_RFR_KNEE	 0.7500
#define SP_LBK_JOINT	-0.4000
#define SP_LBK_SHLDR	 0.0600
#define SP_LBK_KNEE	 0.8500
#define SP_RBK_JOINT	-0.4000
#define SP_RBK_SHLDR	 0.0600
#define SP_RBK_KNEE	 0.8500


/* Staring dead ahead joint angle tolerance */
#define DA_TOLERANCE	1.5*180/M_PI

/* Ideal staring ahead joint values */
#define DA_TILT		0.0
#define DA_PAN		0.0
#define DA_ROLL		0.0

#endif
