/*
 * Utility routines for AIBO FastSLAM.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include <stdlib.h>
#include <math.h>

/* This routine takes the difference between two angles. It assumes that
 * any difference greater than 180 degrees is due to rollover. Input
 * angles should be in the range [0, 2pi). Output angles come in the range
 * [-pi, pi]. */
double find_dtheta(double th1, double th2)
{
  double naive_delta = th2 - th1;

  if(naive_delta <= -M_PI) return naive_delta + 2*M_PI;
  if(naive_delta > M_PI) return naive_delta - 2*M_PI;
  return naive_delta;
}

/* Generates normally-distributed random numbers with the Box-Muller
 * transform. See http://www.taygeta.com/random/gaussian.html */
double normRand()
{
  static int got_leftover_rand=0;
  static double leftover_rand;
  double urand1, urand2, w;

  if(got_leftover_rand) {
    got_leftover_rand = 0;
    return leftover_rand;
  }

  do {
    urand1 = 2.0*rand()/RAND_MAX - 1.0;
    urand2 = 2.0*rand()/RAND_MAX - 1.0;
    w = urand1 * urand1 + urand2 * urand2;
  } while(w >= 1.0);

  w = sqrt((-2.0*log(w)) / w);
  leftover_rand = urand1*w;
  return urand2*w;
}

#ifdef __cplusplus
}
#endif
