#ifndef _AFS_PARTICLE_H_
#define _AFS_PARTICLE_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Defines the particle data structures used for AIBO FastSLAM
 */

#include "Configuration.h"

/** This structure contains a robot pose. Pretty simple. */
typedef struct _afsPose {
  double x;     //!< x value
	double y;     //!< y value
	double theta; //!< theta value
} afsPose;

/** This structure is used within afsLandmarkLoc during the initialization
 * phase, when it is necessary to triangulate the location of the
 * landmark before using regular FastSLAM techniques. */
typedef struct _afsLastObservation {
  int empty;    //!< TSS_TODO
  double x;     //!< x value
	double y;     //!< y value
	double theta; //!< theta value
} afsLastObservation;

/** This structure is used within afsParticle structures to encode
 * information about landmark location */
typedef struct _afsLandmarkLoc {
  /** This indicates whether the landmark has been found yet (PRIMED if so,
   * PRIMING if not). */
  enum { PRIMING, PRIMED } state;

  /** This element is used when the inital location of the landmark must
   * be triangulated. */
  afsLastObservation priming;

  /** Mean of Gaussian landmark location estimate */
  struct {
		double x;     //!< x value
		double y;     //!< y value
  } mean;

  /** Variance of Gaussian landmark location estimate */
  struct {
		double x;     //!< x value
		double xy;    //!< TSS_TODO
		double y;     //!< y value
  } variance;

} afsLandmarkLoc;

/* This is cheating with the namespaces to make C++ work like C code. */
#ifdef __cplusplus
#define PRIMING		afsLandmarkLoc::PRIMING
#define PRIMED		afsLandmarkLoc::PRIMED
#endif

/** This structure contains data for each particle used by the
 * particle filter. Since we have a fixed number of landmarks, we
 * simply fix the number of afsLandmarkLoc structures inside. */
typedef struct _afsParticle {
  /** The robot pose represented by this particle */
  afsPose pose;

  /** The estimated poses of all landmarks in the map */
  afsLandmarkLoc landmarks[AFS_NUM_LANDMARKS];

	//@{
  /** These two variables reflect the weight assigned to this particle
   * from the last sensor measurement. While the particle is still
   * triangulating, there is no weight calculated and gotweight will
   * be false. Otherwise, gotweight is true and the new weight is
   * placed into weight */
  int gotweight;
  double weight;
	//@}

} afsParticle;

/** Initialize a new afsParticle */
void afsParticleInit(afsParticle *p);
/** Copy an afsParticle */
void afsParticleCopy(afsParticle *old, afsParticle *neu);

#ifdef __cplusplus
}
#endif
#endif
