//-*-c++-*-
/*=========================================================================
    CMPack'02 Source Code Release for OPEN-R SDK v1.0
    Copyright (C) 2002 Multirobot Lab [Project Head: Manuela Veloso]
    School of Computer Science, Carnegie Mellon University
  -------------------------------------------------------------------------
    This software is distributed under the GNU General Public License,
    version 2.  If you do not have a copy of this licence, visit
    www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
    Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
    in the hope that it will be useful, but WITHOUT ANY WARRANTY,
    including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -------------------------------------------------------------------------
    Additionally licensed to Sony Corporation under the following terms:

    This software is provided by the copyright holders AS IS and any
    express or implied warranties, including, but not limited to, the
    implied warranties of merchantability and fitness for a particular
    purpose are disclaimed.  In no event shall authors be liable for
    any direct, indirect, incidental, special, exemplary, or consequential
    damages (including, but not limited to, procurement of substitute
    goods or services; loss of use, data, or profits; or business
    interruption) however caused and on any theory of liability, whether
    in contract, strict liability, or tort (including negligence or
    otherwise) arising in any way out of the use of this software, even if
    advised of the possibility of such damage.
  =========================================================================
*/
#ifndef __VISION_INTERFACE_H__
#define __VISION_INTERFACE_H__

#include "Motion/Geometry.h"

class Vision;

namespace VisionInterface {

static const double HorzFOV = 58.0 * M_PI / 180.0;
static const double VertFOV = 48.0 * M_PI / 180.0;

// Bitmasks for which edges of the image an object borders
const uchar OFF_EDGE_LEFT   = 1;
const uchar OFF_EDGE_RIGHT  = 2;
const uchar OFF_EDGE_TOP    = 4;
const uchar OFF_EDGE_BOTTOM = 8;

// High level vision ouput structure for detected objects
struct VObject{
  double confidence; // [0,1] Estimate of certainty
  vector3d loc;      // Relative to front of robot (on ground)
  double left,right; // Angle to left and right of object (egocentric)
  double distance;   // Distance of object (on ground)
  uchar edge;          // Is object on edge of image (bitmasks above)
};

// Colors: (G)reen (O)range (P)urple
const int MARKER_GOG = 0;
const int MARKER_GOP = 1;
const int MARKER_GPG = 2;
const int MARKER_GPO = 3;
const int MARKER_OGO = 4;
const int MARKER_OGP = 5;
const int MARKER_OPG = 6;
const int MARKER_OPO = 7;
const int MARKER_PGO = 8;
const int MARKER_PGP = 9;
const int MARKER_POG = 10;
const int MARKER_POP = 11;
const int RBALL = 12;
const int PBALL = 13;
const int HAND = 14;
const int THING = 15;

/* attention: if you change this constant, please also change
 * AFS_NUM_LANDMARKS in WorldMap2/FastSLAM/Configuration.h. This is a
 * sad way to do things, but it's necessary with our mix of C and C++ code.
 * Sorry about that. --tom */
const int NUM_MARKERS = 12;

const int NUM_VISION_OBJECTS = NUM_MARKERS + 4;

// All the objects we might detect
struct ObjectInfo{
  VObject marker[12];
  VObject rball;
  VObject pball;
  VObject hand;
  VObject thing;
};

// returns the id of the old threshold or -1 on error
int SetThreshold(Vision *vision,int threshold_id);

void SendRawImage(Vision *vision); // Forces the output of the current raw image to the log/spout/wl
void SendRLEImage(Vision *vision); // Forces the output of the current RLE image to the log/spout/wl
void WriteThresholdImage(Vision *vision, char *filename);

} // namespace vision

/*! @file
 * @brief Interfaces between CMVision and the Vision module
 * @author CMU RoboSoccer 2001-2002 (Creator)
 * @author alokl (ported)
 * 
 * @verbinclude CMPack_license.txt
 *
 * $Author: tss $
 * $Name: tekkotsu-1_4 $
 * $Revision: 1.4 $
 * $State: Exp $
 * $Date: 2003/02/13 20:11:07 $
 */
#endif
// __VISION_INTERFACE_H__

