//-*-c++-*-
#ifndef INCLUDED_TextMsgEvent_h
#define INCLUDED_TextMsgEvent_h

#include "EventBase.h"

//! Extends EventBase to also include actual message text
class TextMsgEvent : public EventBase {
 public:
	//! Constructor
  TextMsgEvent() : EventBase(EventBase::textmsgEGID,(unsigned int)-1, EventBase::activateETID,0),_text(""),_token(0) {  }

  //! Constructor, pass a text msg
  TextMsgEvent(const std::string& text) : EventBase(EventBase::textmsgEGID,(unsigned int)-1, EventBase::activateETID,0),_text(text),_token(0) { }
  
  std::string getText() const { return _text; } //!< returns the text
  TextMsgEvent& setText(const std::string& text) { _text=text; return *this; } //!< sets the text
  
  int getToken() const { return _token; } //!< returns the token
  TextMsgEvent& setToken(int token) { _token=token; return *this;} //!< sets the token
      
	virtual unsigned int getBinSize() const {
		unsigned int used=EventBase::getBinSize();
		used+=creatorSize("EventBase::TextMsgEvent");
		used+=_text.size()+stringpad;
		used+=sizeof(_token);
		return used;
	}

	virtual unsigned int LoadBuffer(const char buf[], unsigned int len) {
		unsigned int origlen=len;
		unsigned int used;
		if(0==(used=EventBase::LoadBuffer(buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=checkCreator("EventBase::TextMsgEvent",buf,len,true))) return 0;
		len-=used; buf+=used;
		if(0==(used=decode(_text,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=decode(_token,buf,len))) return 0;
		len-=used; buf+=used;
		return origlen-len;	
	}

	virtual unsigned int SaveBuffer(char buf[], unsigned int len) const {
		unsigned int origlen=len;
		unsigned int used;
		if(0==(used=EventBase::SaveBuffer(buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=saveCreator("EventBase::TextMsgEvent",buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=encode(_text,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=encode(_token,buf,len))) return 0;
		len-=used; buf+=used;
		return origlen-len;
	}

 protected:
  std::string _text; //!< the unmodified arguments passed to the command
  int _token;      //!< for future expansion, to support centralized parsing
};

/*! @file
 * @brief Defines TextMsgEvent, which extends EventBase to also include actual message text
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_4 $
 * $Revision: 1.7 $
 * $State: Exp $
 * $Date: 2003/06/12 23:41:40 $
 */

#endif
