//-*-c++-*-
#ifndef INCLUDED_TimeOutTrans_h_
#define INCLUDED_TimeOutTrans_h_

#include "Behaviors/Transition.h"
#include "Events/EventRouter.h"

//! causes a transition after a specified amount of time has passed
class TimeOutTrans : public Transition, public EventListener {
public:
	//! constructor, specify delay in milliseconds
	TimeOutTrans(StateNode* source, StateNode* destination, unsigned int delay) : Transition(source,destination), EventListener(), d(delay) {}
	
	//!starts timer
	virtual void enable() { resetTimer(); }

	//!stops timer
	virtual void disable() { erouter->forgetListener(this); }

	//!resets timer
	void resetTimer() { erouter->addTimer(this,0,d,false); }

	//!if we receive the timer event, activate()
	virtual void processEvent(const EventBase&) {
		activate();
	}
protected:
	//!amount to delay (in milliseconds) before transition
	unsigned int d;
};

/*! @file
 * @brief Defines TimeOutTrans, which causes a transition after a specified amount of time has passed
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_4 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/03/09 02:45:22 $
 */

#endif
