//-*-c++-*-
#ifndef INCLUDED_SmoothCompareTrans_h_
#define INCLUDED_SmoothCompareTrans_h_

#include "Behaviors/Transitions/CompareTrans.h"

//! A subclass of CompareTrans, which provides monitoring of exponentially weighted averages to a threshold
/*! Has the additional requirement that template types must supply operator*=(float)
 *  and operator+=(T) for the weighted average
 *
 *  The gamma parameter is how much to weight the preceeding value - 1 will cause it to never update, 0 will cause it to only look at most recent.
 *  So, the lower the value, the faster it is to switch, but more prone to noise
 */
template<class T>
class SmoothCompareTrans : public CompareTrans<T> {
public:
	//! constructor, see class notes for information
  SmoothCompareTrans(StateNode* source, StateNode* destination, const T* monitor, typename SmoothCompareTrans<T>::Test_t test, const T& value, const EventBase& poll, float gammap=0)
		: CompareTrans<T>(source,destination,&avg,test,value,poll), avg(*monitor), realmon(monitor), g(gammap)
	{ }

	//!don't care about the event, just a pulse to check the values
	virtual void processEvent(const EventBase& e) {
		avg*=g;
		T x(*realmon);
		x*=(1-g);
		avg+=x;
		CompareTrans<T>::processEvent(e);
	}
protected:
	T avg; //!< the current running average
	const T* realmon; //!< pointer to the value being monitored

	//! the gamma value controlling the exponential average, see the class documentation at the top
	float g; 

private:
	SmoothCompareTrans(const SmoothCompareTrans& node); //!< don't call this
	SmoothCompareTrans operator=(const SmoothCompareTrans& node); //!< don't call this
};

/*! @file
 * @brief Defines SmoothCompareTrans, subclass of CompareTrans, which provides monitoring of exponentially weighted averages to a threshold
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_4 $
 * $Revision: 1.4 $
 * $State: Exp $
 * $Date: 2003/03/09 02:45:22 $
 */

#endif
