//-*-c++-*-
#ifndef INCLUDED_StareAtBallBehavior_h_
#define INCLUDED_StareAtBallBehavior_h_

#include "Behaviors/BehaviorBase.h"
#include "Motion/MotionManager.h"

//! A simple behavior to chase after any objects seen by the vision system
class StareAtBallBehavior : public BehaviorBase {
public:
	//!constructor
	StareAtBallBehavior()
		: BehaviorBase(), headpointer_id(MotionManager::invalid_MC_ID)
	{}
	//!destructor
	virtual ~StareAtBallBehavior() {}

	//! adds a headpointer and a listens for vision events
	virtual void DoStart();

	//! removes motion commands and stops listening
	virtual void DoStop();

	//! sets the head to point at the object and sets the body to move where the head points
	virtual void processEvent(const EventBase& event);
			
	virtual std::string getName() const { return "StareAtBallBehavior"; }
	static std::string getClassDescription() { return "Tracks any objects seen by the vision system"; }

protected:
	MotionManager::MC_ID headpointer_id; //!< a HeadPointerMC object
};

/*! @file
 * @brief Describes StareAtBallBehavior, which runs around after whatever the dog sees
 * @author tss (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_4 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2003/06/05 17:03:15 $
 */

#endif
