//-*-c++-*-
#ifndef INCLUDED_Aibo3DMonitorBehavior_h_
#define INCLUDED_Aibo3DMonitorBehavior_h_

//! Sends current pose to Aibo3D GUI, ignores incoming commands
class Aibo3DMonitorBehavior : public Aibo3DControllerBehavior {
public:
	Aibo3DMonitorBehavior() : Aibo3DControllerBehavior() {}

	virtual std::string getGUIType() const { return "Aibo3D"; }
	virtual unsigned int getPort() const { return config->main.aibo3d_port; }

	virtual std::string getName() const { return "Aibo3D Monitor"; } //!< returns name of behavior
	static std::string getClassDescription() {
		char tmp[20];
		sprintf(tmp,"%d",config->main.aibo3d_port);
		return std::string("Sends current pose on port ")+tmp;
	}	
};

/*! @file
 * @brief Defines Aibo3DMonitorBehavior, which sends current pose to Aibo3D GUI, ignores incoming commands
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_4 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/07/07 01:00:07 $
 */

#endif
