//-*-c++-*-
#ifndef INCLUDED_ValueEditControl_h
#define INCLUDED_ValueEditControl_h

#include "StringInputControl.h"
#include "Events/EventListener.h"
#include "Events/EventBase.h"
#include <vector>
#include "Motion/MotionManager.h"
#include "Events/EventRouter.h"
#include "Shared/WorldState.h"
#include <sstream>

//! allows real-time modification of a value through a pointer @todo needs some work to really be useful again
template< class T >
class ValueEditControl : public StringInputControl, public EventListener {
 public:
	//!constructor
	ValueEditControl(const std::string& n, T* t) : StringInputControl(n,"Please enter a new value for "+n), target(t), cur(), copies() {}
	//!constructor
	ValueEditControl(const std::string& n, const std::string& p, T* t) : StringInputControl(n,p), target(t), cur(), copies() {}
	//!constructor
	ValueEditControl(const std::string& n, const std::string& d, const std::string& p, T* t) : StringInputControl(n,d,p), target(t), cur(), copies() {}
	//!copy constructor
	ValueEditControl(const ValueEditControl<T>& vec) : StringInputControl(vec), target(vec.target), cur(vec.cur), copies(vec.copies) {}
	//!assignment operator
	ValueEditControl operator=(const ValueEditControl<T>& vec) { StringInputControl::operator=(vec); target=vec.target; cur=vec.cur; copies=vec.copies; return *this; }
	//!destructor
	virtual ~ValueEditControl() {}

	//!reads in current value from target
	virtual ControlBase * activate(MotionManager::MC_ID display, Socket * gui) {
		cur=*target;
		erouter->forgetListener(this);
		return StringInputControl::activate(display,gui);
	}
	//! will increment/decrement the current and then assign it to the target when head buttons pressed
	virtual void processEvent(const EventBase& e) {
		switch(e.getSourceID()) {
		case ButtonSourceID::HeadFrButSID: doNextItem(); doSelect(); break;
		case ButtonSourceID::HeadBkButSID: doNextItem(); doSelect(); break;
			//		case ButtonSourceID::ChinButSID: doSelect(); break;
		default:
			cout << "*** WARNING ValueEditControl got an unasked for event" << endl;
			break;
		}
	}
	//! displays current value
	/*	virtual void refresh() {
			cout << getName();
			if(cur!=*target)
			cout << ": " << cur;
			cout << endl;
			StringInputControl::refresh();
			}*/
	//! request to continue receiving events so we can modify the value while running
	virtual void pause() {
		erouter->addListener(this,EventBase(EventBase::buttonEGID,ButtonSourceID::HeadFrButSID,EventBase::deactivateETID,0));
		erouter->addListener(this,EventBase(EventBase::buttonEGID,ButtonSourceID::HeadBkButSID,EventBase::deactivateETID,0));
		//		erouter->addListener(this,EventBase(EventBase::buttonEGID,ButtonSourceID::ChinButSID,EventBase::deactivateETID,0));
		StringInputControl::pause();
	}

	//! if the value of the #target!=#cur, assigns the current value to the target and all the #copies
	virtual ControlBase * doSelect()   {
		if(*target!=cur) {
			*target=cur;
			for(typename std::vector<T*>::iterator it=copies.begin(); it!=copies.end(); it++)
				**it=cur;
			//			if(display) {
			//				display->flash(FaceLEDMask,100);
			//				display->clear();
			//			}
			cout << getName() << " set to " << *target << endl;
		}
		return NULL;
	}
	//! adds one to the current value
	virtual ControlBase * doNextItem() {
		cur++;
		refresh();
		return this;
	}
	//! subtracts one from the current value
	virtual ControlBase * doPrevItem() {
		cur--;
		refresh();
		return this;
	}

	virtual ControlBase * takeInput(const std::string& str) {
		cur = (T)atof(str.c_str());
		return doSelect();
	}

	/*!@name Target
	 * accessors for the target pointer */
	virtual T* getTarget() const { return target; } //!< returns the target pointer
	virtual ValueEditControl& setTarget(T* t) { target=t; return *this; } //!< sets the target pointer - the object pointed to will be overwritten on activate() @return @c *this
	//@}

	/*!@name Copies
	 * accessors for the copies vector, so you can assign the same value to several places if you need to */
	virtual std::vector<T*>& getCopies() { return copies; } //!< returns a reference to the vector #copies
	virtual ValueEditControl& addCopy(T* t) { copies.push_back(t); return *this; } //!< #copies.push_back(t)
	//@}

	//! shows current value
	virtual std::string getName() const {
		std::stringstream ss;
		ss << StringInputControl::getName() << " (" << *target << ")";
		return ss.str();
	}

 protected:
	T* target; //!< the main target
	T cur; //!< the value to use when set
	std::vector<T*> copies; //!< additional targets
};

/*! @file
 * @brief Defines ValueEditControl class, which will allow modification of a value through a pointer
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_4 $
 * $Revision: 1.8 $
 * $State: Exp $
 * $Date: 2003/06/09 20:10:17 $
 */

#endif
