#include "StringInputControl.h"
#include "Wireless/Wireless.h"
#include "Motion/MMAccessor.h"
#include "Motion/LedMC.h"
#include "Motion/MotionManager.h"

ControlBase* StringInputControl::activate(MotionManager::MC_ID disp_id, Socket* gui) {
	display_id=disp_id;
	gui_comm=gui;
	return doReadStdIn(userPrompt);
}

void StringInputControl::refresh() {
	ControlBase::doReadStdIn(userPrompt);
}

ControlBase* StringInputControl::doReadStdIn(const std::string& prompt/*=std::string()*/) {
	if(prompt.size()==0)
		return ControlBase::doReadStdIn(userPrompt);
	else
		return ControlBase::doReadStdIn(prompt);
}

/*! @file
 * @brief Implements StringInputControl, which prompts for and stores a string from the user
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_4 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2003/06/12 23:41:36 $
 */

