#ifndef INCLUDED_LoadWalkControl_h
#define INCLUDED_LoadWalkControl_h

#include "FileBrowserControl.h"
#include "Motion/WalkMC.h"
#include "Shared/Config.h"
#include <string>

//! When activated, loads a set of walk parameters from a file specified by user
class LoadWalkControl : public FileBrowserControl {
public:
	//! constructor, pass the MC_ID of the WalkMC which you want to save
	LoadWalkControl(const std::string& n, MotionManager::MC_ID w)
		: FileBrowserControl(n,"Loads a set of walk parameters from a file specified by user",config->motion.root), walk_id(w)
	{
		setFilter("*.prm");
	}
	//! destructor
	virtual ~LoadWalkControl() {}

protected:
	//!does the actual loading of the MotionSequence
	virtual ControlBase* selectedFile(const std::string& f) {
		WalkMC* walk = (WalkMC*)motman->checkoutMotion(walk_id);
		walk->load(f.c_str());
		motman->checkinMotion(walk_id);
		return NULL;
	}

	MotionManager::MC_ID walk_id; //!< the MC_ID of the walk to load into
};

/*! @file
 * @brief Defines LoadWalkControl, which when activated, loads a set of walk parameters from a file read from cin.
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_4 $
 * $Revision: 1.4 $
 * $State: Exp $
 * $Date: 2003/06/10 00:53:48 $
 */

#endif
