import java.io.InputStream;
import java.net.Socket;

public class VisionRleListener extends TCPListener {
  byte[] _data;
  byte[] _outd;
  byte[] _sizeb;
  boolean updatedFlag;
  int width=176;
  int height=144;
  static final boolean _debug=false;

  void connected(Socket socket) {
    _data=new byte[22*144*3*2];
    _outd=new byte[176*144];
    _isConnected=true;
    try {
      InputStream in=socket.getInputStream();
      while (true) {
        int size=readInt(in);
        size=size*3;
        readBytes(_data, in, size);
        decodeRLE(size);
        updatedFlag=true;
      }
    } catch (Exception ex) { }

    try { socket.close(); } catch (Exception ex) { }
    _isConnected=false;
  }

  void decodeRLE(int pktSize) {
    int curx=0, cury=0;
    int dlength=pktSize;
    int dpos=0;

    for (; dlength>=3 && cury<height;) {
      byte color;
      color=_data[dpos++];
      color++;
      int x=b2i(_data[dpos++]);
      int len=b2i(_data[dpos++]);
      dlength-=3;
      if (x < curx) {
        if (_debug) System.out.println("backwards x movement");
        break;
      }

      for (; curx < x; curx++)
        _outd[cury*width+curx]=1;

      if (curx+len>width) {
        if (_debug) System.out.println("run past end");
        break;
      }

      for (; len>0; len--, curx++)
        _outd [cury*width+curx]=color;
      if (curx==width) {
        cury++;
        curx=0;
      }
    }
    if (cury!=height) {
      if (_debug) System.out.println("early end of data\n");
    }
  }

  public boolean hasData() {
    return updatedFlag;
  }
 
  public byte[] getData() {
//    frameTimer();
//    synchronized (_outd) {
      updatedFlag=false;
      return _outd;
//    }
  }

  public boolean isConnected() {
    return _isConnected;
  }

  public VisionRleListener() { super(); }
  public VisionRleListener(int port) { super(port); }
  public VisionRleListener(String host, int port) { super(host,port); }
}
