import java.io.InputStream;
import java.net.Socket;
import javax.swing.JFrame;

public class VisionRawListener extends TCPListener {
  byte[] _data;
  byte[] _outd;
  int imgWidth=88;
  int imgHeight=72;
	int channels=3;
  int pktSize=imgWidth*imgHeight*channels;
  int bytesRead;
  boolean _updatedFlag;

  void connected(Socket socket) {
    try {
      InputStream in=socket.getInputStream();
       _data=new byte[pktSize];
       _outd=new byte[pktSize];
       _isConnected=true;
      while (true) {
        int br;
        bytesRead=0;
        while(bytesRead<pktSize) {
          br=in.read(_data,bytesRead,
                    (pktSize-bytesRead>1024)?1024:(pktSize-bytesRead));
          bytesRead=bytesRead+br;
        }
        synchronized(_outd) {
          byte[] temp=_data;
          _data=_outd;
          _outd=temp;
          _updatedFlag=true;
        }
      }
    } catch (Exception ex) { }

    try { socket.close(); } catch (Exception ex) { }
    _isConnected=false;
    _updatedFlag=true;
  }
 
  public boolean hasData() {
    return _updatedFlag;
  }
 
  public byte[] getData() {
//    frameTimer();
    synchronized (_outd) {
      _updatedFlag=false;
      return _outd;
    }
  }

  public boolean isConnected() {
    return _isConnected;
  }

  public VisionRawListener() { super(); }
  public VisionRawListener(int port) { super(port); }
  public VisionRawListener(String host, int port) { super(host,port); }
}
