import java.net.ServerSocket;
import java.net.Socket;

public abstract class TCPListener extends Listener {
  abstract void connected(Socket socket);

  void runServer() {
    Thread me = Thread.currentThread();
    try { _serverSocket=new ServerSocket(_port); }
    catch (Exception ex) {
      System.out.println("port "+_port+": "+ex);
      return;
    }

    while (me == _listenerThread && !destroy) {
      try {
        _socket=_serverSocket.accept();
        connected(_socket);
      } catch (Exception ex) { }
    }
  }

  void runConnect() {
    int attempts=0;
    Thread me = Thread.currentThread();
		System.err.println("TCPListener port "+_port+" - Connecting...");
    while (me==_listenerThread && !destroy) {
      try {
        _socket=new Socket(_host,_port);
        attempts=0;
        connected(_socket);
				System.err.println("TCPListener port "+_port+" - Disconnected, attempting to reestablish...");
      } catch (Exception ex) {}
      attempts++;
			if(destroy) {
				System.out.println("Connection closed.");
				break;
			}
      if(attempts%10==0)
        System.err.println("TCPListener port "+_port+" - Waiting for connection... ("+attempts+" attempts)");
      try {
	      Thread.sleep(500);
      } catch (Exception ex) {}
    }
  }

  public void close() {
    _listenerThread=null;
    try { _socket.close(); } catch (Exception ex) { }
    if (_isServer)
      try { _serverSocket.close(); } catch (Exception ex) { }
  }

  public TCPListener() { super(); }
  public TCPListener(int port) { super(port); }
  public TCPListener(String host, int port) { super(host,port); }

  Socket _socket;
  ServerSocket _serverSocket;
}
