import java.io.*;
import java.net.Socket;
import java.util.Vector;
import java.lang.Integer;

public class ControllerListener extends TCPListener {
	boolean _updatedFlag=false;
	Vector _titles;
	Vector _menus;
	Vector _selections;
	String _status;
	PrintStream _out;
	ControllerGUI listener;
	
	public class MenuEntry {
		boolean hasSubmenu;
		boolean selected;
		String title;
		String description;
		MenuEntry(boolean hasSubmenu, boolean selected, String title, String description) {
			this.hasSubmenu=hasSubmenu;
			this.selected=selected;
			this.title=title;
			this.description=description;
		}
		public String toString() { return title; }
	}
	
	static String escapize(Vector path) {
		System.out.println("Escapize:"+path);
		StringBuffer p=new StringBuffer();
		System.out.println("Escapized1:"+p);
		for(int i=0; i<path.size(); i++) {
			p.append("/");
			System.out.println("Escapized2:"+p);
			p.append(((String)path.get(i)).replaceAll("\\\\","\\\\\\\\").replaceAll("/","\\\\/"));
			System.out.println("Escapized3:"+p);
		}
		System.out.println("Escapized:"+p);
		return p.toString();
	}

	public Vector buildSelectionPath(int index) {
		Vector ans=buildSelectionPath();
		ans.add(((Vector)_menus.lastElement()).get(index).toString());
		return ans;
	}
		
	public Vector buildSelectionPath() {
		Vector ans=new Vector();
		for(int i=0; i<_menus.size()-1; i++)
			ans.add(((Vector)_menus.get(i)).get(((Integer)_selections.get(i)).intValue()).toString());
		return ans;
	}
		
	void sendSelectionPath(Vector path) {
		try {
			_out.println("!select");
		} catch (Exception ex) { }
	}
	
	void sendSelect() {
		try {
			_out.println("!select");
		} catch (Exception ex) { }
	}
	
	void sendReturn() {
		try {
			_out.println("!cancel");
		} catch (Exception ex) { }
	}
	
	void sendRefresh() {
		try {
			_out.println("!refresh");
		} catch (Exception ex) { }
	}
	
	void sendInput(String s,Vector path) {
		try {
			Vector cur=buildSelectionPath();
			sendSelectionPath(path);
			_out.println(s);
			sendSelectionPath(cur);
		} catch (Exception ex) { }
	}
	
	void sendInput(String s) {
		try {
			_out.println(s);
		} catch (Exception ex) { }
	}
	
	void sendSelection(int sel[]) {
		try {
			String msg="!hilight";
			for(int i=0; i<sel.length; i++) {
				msg+=" ";
				msg+=sel[i];
			}
			_out.println(msg);
		} catch (Exception ex) { }
	}

	void connected(Socket socket) {
		_isConnected=true;
		_menus=new Vector();
		_menus.add(new Vector());
		_titles=new Vector();
		_titles.add("Unset");
		System.out.println("connection opened");
		try {
			InputStream sin=socket.getInputStream();
			_out=new PrintStream(socket.getOutputStream());
			_out.println("!refresh");
			while (true) {
				String msgtype=readLine(sin);
				if(!_isConnected) break;
				//				System.out.println("Received: "+msgtype);
				synchronized(_menus) {
					if(msgtype.equals("push")) {
						_menus.add(new Vector());
						_titles.add("Unset");
					}
					if(msgtype.equals("refresh") || msgtype.equals("push")) {
						String last=readLine(sin);
						if(!_isConnected) break;
						_titles.set(_titles.size()-1,last);
						int len=Integer.parseInt(readLine(sin));
						if(!_isConnected) break;
						Vector menu=(Vector)_menus.lastElement();
						menu.clear();
						for(;len>0;len--) {
							int x=Integer.parseInt(readLine(sin));
							if(x==-1) {
								_isConnected=false;
								break;
							}
							int sel=Integer.parseInt(readLine(sin));
							if(x==-1) {
								_isConnected=false;
								break;
							}
							last=readLine(sin);
							if(!_isConnected) break;
							String descript=readLine(sin);
							if(!_isConnected) break;
							menu.add(new MenuEntry((x>0),(sel>0),last,descript));
						}
						_status="";
						if(!_isConnected) break;
					} else if(msgtype.equals("pop")) {
						_menus.remove(_menus.size()-1);
						_titles.remove(_titles.size()-1);
					} else if(msgtype.equals("reset")) {
						_menus.clear();
						_menus.add(new Vector());
						_titles.clear();
					} else if(msgtype.equals("status")) {
						_status=readLine(sin);
						if(!_isConnected) break;
					} else {
						System.err.println("ControllerListener - Invalid message type");
					}
					_updatedFlag=true;
					if(listener!=null)
						listener.repaint();
					else
						System.out.println("null listener");
				}
			}
		} catch (Exception ex) { ex.printStackTrace(System.out); }
		
		try { socket.close(); } catch (Exception ex) { }

		while(_updatedFlag)
				try { Thread.sleep(100); } catch (Exception ex) {}

		_isConnected=false;
		_updatedFlag=true;
		if(listener!=null)
			listener.repaint();
		//The sleep is to get around the socket still listening after being closed thing
		System.out.println("connection closed... reconnect after 5 seconds");
		try { Thread.sleep(5000); } catch (Exception ex) {}
	}
 
	public boolean hasData() {
		return _updatedFlag;
	}

	public boolean isConnected() {
		return _isConnected;
	}

	public ControllerListener() { super(); }
	public ControllerListener(int port) { super(port); }
	public ControllerListener(String host, int port) { super(host,port); }
}
