import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.beans.*;
import java.util.*;

//Admittedly a little sloppy, but I don't want to spend forever on this...

public class ControllerGUI extends JFrame implements ActionListener {
	JList menu;
	JScrollPane menuScroll;
	JLabel title;
	JLabel status;
	JList bookmarks;
	ControllerListener comm;
	JButton cancelBut;
	JButton refreshBut;
	JButton reconnectBut;
	JTextField inputField;
	boolean isUpdating=false;
	
	ControllerGUI(String addr, int port) {
		pack();
		setLocation(50,50);
		show();
		comm = new ControllerListener(addr,port);
		comm.listener=this;
	}
	
	// Disables the component if there's nothing selected to apply it to
	public class AutoDisableListener implements PropertyChangeListener, ListSelectionListener {
		JComponent target;
		public AutoDisableListener(JComponent target, JList source) {
			this.target=target;
			source.addPropertyChangeListener(this);
			source.addListSelectionListener(this);
		}
		public void propertyChange(PropertyChangeEvent evt) {
			target.setEnabled(!((JList)evt.getSource()).isSelectionEmpty());
		}
		public void valueChanged(ListSelectionEvent evt) {
			target.setEnabled(!((JList)evt.getSource()).isSelectionEmpty());
		}
	}
	
	final static ImageIcon rarrow = new ImageIcon("images/rarrow.png");
	final static ImageIcon larrow = new ImageIcon("images/larrow.png");
	final static ImageIcon carrows = new ImageIcon("images/chasingarrows.png");

	public class MyCellRenderer implements ListCellRenderer {
		public Component getListCellRendererComponent(JList list,Object value,int index,boolean isSelected,boolean cellHasFocus) {
			ControllerListener.MenuEntry me=(ControllerListener.MenuEntry)value;
			/*			if(me.hasSubmenu) {
						setIcon(rarrow);
						setHorizontalTextPosition(SwingConstants.RIGHT);
						setIconTextGap(5);
						} else
						setIconTextGap(5+rarrow.getIconWidth());
			*/			
			//System.out.println(this.getText()+" "+me.selected+" "+isSelected);
			int numpre=(int)(Math.log(list.getModel().getSize()-1)/Math.log(10))-(index==0?0:(int)(Math.log(index)/Math.log(10)));
			StringBuffer pre=new StringBuffer();
			for(int i=0;i<numpre;i++)
				pre.append(" ");
			JLabel title=new JLabel(pre.toString()+index+". "+me.title);
			title.setBackground(me.selected?list.getSelectionBackground():list.getBackground());
			title.setForeground(me.selected?list.getSelectionForeground():list.getForeground());
			title.setEnabled(list.isEnabled());
			title.setFont(list.getFont());
			title.setOpaque(true);
			title.setPreferredSize(new Dimension(list.getSize().width,title.getPreferredSize().height));
			//Vector tmp2=new Vector();
			//for(int i=0;i<1000000;i++) {tmp2.add(new Integer(0));tmp2.remove(tmp2.size()-1);}
			if(me.hasSubmenu) {
				Box tmp=Box.createHorizontalBox();
				tmp.add(title);
				//				tmp.add(Box.createHorizontalGlue());
				JLabel arr=new JLabel(rarrow);
				arr.setEnabled(list.isEnabled());
				tmp.add(arr);
				if(me.description.length()!=0)
					tmp.setToolTipText(me.description);
				return tmp;
			} else {
				Box tmp=Box.createHorizontalBox();
				tmp.add(title);
				tmp.add(Box.createHorizontalStrut(rarrow.getIconWidth()));
				if(me.description.length()!=0)
					tmp.setToolTipText(me.description);
				return tmp;
			}
		}
	} 
	 
	public class JListDoubleClick extends MouseAdapter {
		ControllerGUI gui;
		JListDoubleClick(ControllerGUI gui) { this.gui=gui; }
		public void mouseClicked(MouseEvent e) {
			if (e.getClickCount() == 2) {
				int index = ((JList)e.getSource()).locationToIndex(e.getPoint());
				gui.doubleClicked((JList)e.getSource(),index);
			}
		}
	}

	public class MySelectionListener implements ListSelectionListener {
		ControllerGUI gui;
		MySelectionListener(ControllerGUI gui) { this.gui=gui; }
		public void valueChanged(ListSelectionEvent e) {
			if(!gui.isUpdating && !e.getValueIsAdjusting())
				gui.comm.sendSelection(((JList)e.getSource()).getSelectedIndices());
		}
	}
 	
	public class EscFilter extends KeyAdapter {
		JButton trigger;
		EscFilter(JButton trigger) { this.trigger=trigger; }
		public void keyReleased(KeyEvent evt) {
			if(evt.getKeyChar()==(char)27)
				trigger.doClick();
		}
	}
	public class ReturnFilter extends KeyAdapter {
		ControllerGUI gui;
		ReturnFilter(ControllerGUI gui) { this.gui=gui; }
		public void keyReleased(KeyEvent evt) {
			if(evt.getKeyCode()==KeyEvent.VK_ENTER)
				gui.doubleClicked((JList)evt.getSource(),0);
		}
	}
 	

	void updated() {
			//		System.out.println("updated");
		isUpdating=true;
		Point p=menuScroll.getViewport().getViewPosition();  

		//		bookmarks.setEnabled(comm._isConnected);
		cancelBut.setEnabled(comm._isConnected);
		refreshBut.setEnabled(comm._isConnected);
		inputField.setEnabled(comm._isConnected);
		if(!comm._isConnected) {
			title.setText("-");
			menu.setListData(new Vector());
			status.setText("Reconnecting...");
		} else {
			title.setText((String)comm._titles.lastElement());
			Vector menuitems=(Vector)comm._menus.lastElement();
			synchronized(menu) {
				menu.setValueIsAdjusting(true);
				menu.setListData(menuitems);
				Vector sels=new Vector();
				for(int i=0; i<menuitems.size(); i++)
					if(((ControllerListener.MenuEntry)menuitems.get(i)).selected)
						sels.add(new Integer(i));
				int[] selsArr=new int[sels.size()];
				for(int i=0; i<selsArr.length; i++)
					selsArr[i]=((Integer)sels.get(i)).intValue();
				menu.setSelectedIndices(selsArr);
				menu.setValueIsAdjusting(false);
			}
			status.setText(comm._status.length()>0?comm._status:"Connected.");
		}
		menuScroll.getViewport().setViewPosition(p);
		isUpdating=false;
		comm._updatedFlag=false;
	}

	public void paint(Graphics g) {
		if(comm!=null && comm._updatedFlag)
			updated();
		super.paint(g);
	}
	
	public void actionPerformed(ActionEvent evt) {
		if(evt.getSource()==cancelBut) {
			//System.out.println("cancel button clicked");
			comm.sendReturn();
		} else if(evt.getSource()==refreshBut) {
			//System.out.println("refresh button clicked");
			comm.sendRefresh();
		} else if(evt.getSource()==inputField) {
			//System.out.println("input: "+inputField.getText());
			int[] sel=menu.getSelectedIndices();
			if(sel.length==0 || inputField.getText().charAt(0)=='!')
				comm.sendInput(inputField.getText());
			else
				comm.sendInput("!input "+inputField.getText());
			/*else if(sel.length==1) {
				comm.sendSelectionPath(comm.buildSelectionPath(sel[0]));
				comm.sendInput(inputField.getText());
			} else
				for(int i=0; i<sel.length; i++)
					comm.sendInput(inputField.getText(),comm.buildSelectionPath(sel[i]));
			*/
			inputField.setText("");
		} else if(evt.getSource()==reconnectBut) {
			int port=comm._port;
			String addr=comm._host;
			comm.kill();
			comm = new ControllerListener(addr,port);
			comm.listener=this;
		}
	}
	
	public void doubleClicked(JList list, int index) {
		if(list==menu) {
			Vector items=(Vector)comm._menus.lastElement();
			//System.out.println(items.get(index)+" selected");
			comm.sendSelect();
			/*			int[] sel=menu.getSelectedIndices();
						if(sel.length==1) {
						comm.sendSelectionPath(comm.buildSelectionPath(sel[0]));
						} else if(sel.length>1) {
						Vector selectionPaths=new Vector();
						for(int i=0; i<sel.length; i++)
						selectionPaths.add(comm.buildSelectionPath(sel[i]));
						for(int i=0; i<selectionPaths.size(); i++)
						comm.sendSelectionPath((Vector)selectionPaths.get(i));
						}
			*/
			inputField.setText("");
		} else if(list==bookmarks) {
			//todo
		} else {
			System.out.println("Unknown list double-clicked");
		}
	}
	
	public class ConstSizeJButton extends JButton {
		Dimension dim;
		ConstSizeJButton(String s, ImageIcon i, Dimension d) { super(s,i); dim=d; }
		public Dimension getPreferredSize() { return dim; }
		public Dimension getMinimumSize() { return dim; }
		public Dimension getMaximumSize() { return dim; }
		public Dimension getSize() { return dim; }
	}

	protected void frameInit() {
		super.frameInit();
		
		int spacer_size=10;
	
		
		setTitle("Controller Menus");
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(Box.createHorizontalStrut(spacer_size),BorderLayout.WEST);
		getContentPane().add(Box.createHorizontalStrut(spacer_size),BorderLayout.EAST);
		getContentPane().add(Box.createVerticalStrut(spacer_size),BorderLayout.NORTH);
		getContentPane().add(Box.createVerticalStrut(spacer_size),BorderLayout.SOUTH);
		
		menu=new JList();
		menu.setCellRenderer(new MyCellRenderer());
		menu.setFixedCellWidth(165);
		menu.addMouseListener(new JListDoubleClick(this)); 
		menu.addListSelectionListener(new MySelectionListener(this));
		
		JPanel content=new JPanel(new BorderLayout());
		Box titleBox=Box.createVerticalBox();
		title=new JLabel("-");
		title.setFont(new Font(title.getFont().getFontName(),Font.BOLD,title.getFont().getSize()));
		title.setAlignmentX(0);
		titleBox.add(title);
		titleBox.add(Box.createVerticalStrut(spacer_size));
		content.add(titleBox,BorderLayout.NORTH);
		
		Box menuBox=Box.createVerticalBox();
		menuScroll=new JScrollPane(menu);
		menuScroll.setAlignmentX(0.5f);
		menuBox.add(menuScroll);
		{
			Box tmp=Box.createHorizontalBox();
			cancelBut=new JButton("Cancel");
			Dimension dim=new Dimension(cancelBut.getPreferredSize().width+larrow.getIconWidth()+cancelBut.getIconTextGap(),cancelBut.getPreferredSize().height);
			tmp.add(cancelBut=new ConstSizeJButton("Cancel",larrow,dim));
			cancelBut.setEnabled(false);
			cancelBut.addActionListener(this);
			cancelBut.setToolTipText("Returns to previous control");
			tmp.add(refreshBut=new JButton("Refresh"));
			refreshBut.setEnabled(false);
			refreshBut.addActionListener(this);
			refreshBut.setToolTipText("Requests a menu refresh (handy if item names are dynamic)");
			tmp.setAlignmentX(0.5f);
			menuBox.add(tmp);
		}
		content.add(menuBox,BorderLayout.CENTER);

		Box statusbox=Box.createVerticalBox();
		statusbox.add(Box.createVerticalStrut(spacer_size));
		{
			JSeparator sep=new JSeparator(SwingConstants.HORIZONTAL);
			statusbox.add(sep);
		}
		statusbox.add(Box.createVerticalStrut(spacer_size-2));
		{
			Box tmp=Box.createHorizontalBox();
			status=new JLabel("Connecting...");
			tmp.add(status);
			tmp.add(Box.createHorizontalGlue());
			reconnectBut=new JButton(carrows);
			reconnectBut.setPreferredSize(new Dimension(carrows.getIconWidth(),carrows.getIconHeight()));
			reconnectBut.addActionListener(this);
			reconnectBut.setToolTipText("Drop current connection and try again.");
			tmp.add(reconnectBut);
			statusbox.add(tmp);
		}
		content.add(statusbox, BorderLayout.SOUTH);
		
		Box p=Box.createVerticalBox();
		p.add(new JLabel("Send Input:"));
		p.add(inputField=new JTextField());
		inputField.setEnabled(false);
		inputField.addActionListener(this);
		inputField.setMaximumSize(new Dimension(inputField.getMaximumSize().width,inputField.getPreferredSize().height));
		inputField.setToolTipText("Text from here is passed to selected controls, or the current control if no selection");

		p.add(Box.createVerticalStrut(spacer_size));
		{
			JSeparator sep=new JSeparator(SwingConstants.HORIZONTAL);
			sep.setMaximumSize(new Dimension(sep.getMaximumSize().width,spacer_size));
			p.add(sep);
		}
		p.add(Box.createVerticalStrut(spacer_size-2));
		
		{
			Box tmp=Box.createHorizontalBox();
			JButton but;
			but=new JButton("Raw Cam");
			but.setEnabled(false);
			but.setToolTipText("Raw vision - Sorry not ready yet - check back next week!");
			tmp.add(but);
			but=new JButton("Seg. Cam");
			but.setEnabled(false);
			but.setToolTipText("Segmented vision - Sorry not ready yet - check back next week!");
			tmp.add(but);
			tmp.setAlignmentX(0.0f);
			p.add(tmp);
		}
		
		p.add(Box.createVerticalStrut(spacer_size));
		{
			JSeparator sep=new JSeparator(SwingConstants.HORIZONTAL);
			sep.setMaximumSize(new Dimension(sep.getMaximumSize().width,spacer_size));
			p.add(sep);
		}
		p.add(Box.createVerticalStrut(spacer_size-2));
		
		p.add(new JLabel("Bookmarks:"));
		String[] test={"Not yet","implemented"};
		bookmarks=new JList(test);
		bookmarks.setEnabled(false);
		{
			JScrollPane tmp=new JScrollPane(bookmarks);
			tmp.setAlignmentX(0);
			p.add(tmp);
		}

		{
			Box bbox=Box.createHorizontalBox();
			bbox.setAlignmentX(0);
			JButton tmp;
			bbox.add(tmp=new JButton("Add"));
			//			new AutoDisableListener(tmp,menu);
			tmp.setEnabled(false);
			bbox.add(tmp=new JButton("Remove"));
			new AutoDisableListener(tmp,bookmarks);
			tmp.setEnabled(false);
			p.add(bbox);
		}

		{
			JPanel p2=new JPanel(new BorderLayout());
			p2.add(p,BorderLayout.EAST);
			p2.add(Box.createHorizontalStrut(spacer_size),BorderLayout.WEST);
			content.add(p2, BorderLayout.EAST);
		}
		
		getContentPane().add(content,BorderLayout.CENTER);
		EscFilter esc=new EscFilter(cancelBut);
		addKeyListener(esc);
		inputField.addKeyListener(esc);
		menu.addKeyListener(esc);
		menu.addKeyListener(new ReturnFilter(this));
		

	}
	
	public void show() {
		super.show();
		menu.requestFocus();
	}
	
	public static void main(String s[]) throws java.lang.InterruptedException {
		if(s.length<1) {
			System.out.println("Usage: java ControllerGUI host [port]");
			System.out.println("       if port is not specified, it defaults to 10020");
			System.exit(2);
		}
		int port=10020;
		if(s.length>1)
			port=Integer.parseInt(s[1]);
		ControllerGUI f = new ControllerGUI(s[0],port);
		f.addWindowListener(new WindowAdapter() {
				public void windowClosing(WindowEvent e) {System.exit(0);}
			});
	}
}




/*
	public class MySelectionModel extends DefaultListSelectionModel {
		Vector curmenu;
		ControllerGUI gui;
		public boolean isUpdate;

		public MySelectionModel(ControllerGUI gui) {
			this.gui=gui;
		}
		public void updated(Vector curmenu) {
			this.curmenu=curmenu;
			Vector sel=getSelection();
			super.clearSelection();
			//			super.removeSelectionInterval(0,curmenu.size());
			for(int i=0; i<sel.size();i++) {
				int s=((Integer)sel.get(i)).intValue();
				super.addSelectionInterval(s,s);
			}
			isUpdate=false;
		}
		public boolean isSelectedIndex(int index) {
			return ((ControllerListener.MenuEntry)curmenu.get(index)).selected;
		}
		public boolean isSelectionEmpty() {
			return getSelection().size()>0;
		}
		public void clearSelection() {
			if(!isUpdate)
				gui.comm.sendSelection(new Vector());
		}
		public int getMinSelectionIndex() {
			for(int i=0; i<curmenu.size(); i++)
				if(((ControllerListener.MenuEntry)curmenu.get(i)).selected)
					return i;
			return -1;
		}
		public int getMaxSelectionIndex() {
			for(int i=curmenu.size()-1; i>-1; i--)
				if(((ControllerListener.MenuEntry)curmenu.get(i)).selected)
					return i;
			return -1;
		}
		public void addSelectionInterval(int index0, int index1) {
			int min=index0<index1?index0:index1;
			int max=index0>index1?index0:index1;
			if(min<0) min=0;
			if(max>curmenu.size()) max=curmenu.size()-1;

			Vector ans=new Vector();
			for(int i=0; i<min; i++)
				if(((ControllerListener.MenuEntry)curmenu.get(i)).selected)
					ans.add(new Integer(i));
			for(int i=min; i<=max; i++)
				ans.add(new Integer(i));
			for(int i=max+1; i<curmenu.size(); i++)
				if(((ControllerListener.MenuEntry)curmenu.get(i)).selected)
					ans.add(new Integer(i));
			if(!isUpdate)
				gui.comm.sendSelection(ans);
		}
		public void removeSelectionInterval(int index0, int index1) {
			int min=index0<index1?index0:index1;
			int max=index0>index1?index0:index1;
			if(min<0) min=0;
			if(max>curmenu.size()) max=curmenu.size()-1;

			Vector ans=new Vector();
			for(int i=0; i<min; i++)
				if(((ControllerListener.MenuEntry)curmenu.get(i)).selected)
					ans.add(new Integer(i));
			for(int i=max+1; i<curmenu.size(); i++)
				if(((ControllerListener.MenuEntry)curmenu.get(i)).selected)
					ans.add(new Integer(i));
			if(!isUpdate)
				gui.comm.sendSelection(ans);
		}
		public void setSelectionInterval(int index0, int index1) {
			int min=index0<index1?index0:index1;
			int max=index0>index1?index0:index1;
			if(min<0) min=0;
			if(max>curmenu.size()) max=curmenu.size()-1;

			Vector ans=new Vector();
			for(int i=min; i<=max; i++)
				ans.add(new Integer(i));
			if(!isUpdate)
				gui.comm.sendSelection(ans);
		}

		private Vector getSelection() {
			Vector ans=new Vector();
			for(int i=0; i<curmenu.size(); i++)
				if(((ControllerListener.MenuEntry)curmenu.get(i)).selected)
					ans.add(new Integer(i));
			return ans;
		}
	}

	MySelectionModel selmodel;

*/
