import javax.media.j3d.*;
import javax.vecmath.*;
import java.util.*;
import java.lang.*;

import com.sun.j3d.loaders.Scene;

public class Aibo3DForward {
  Scene _scene;
  Hashtable _namedObjects;

  AiboJoint head;
  AiboJoint neck;
  AiboJoint jaw;
  AiboJoint tail;
  AiboJoint thigh_fl;
  AiboJoint knee_fl;
  AiboJoint thigh_fr;
  AiboJoint knee_fr;
  AiboJoint thigh_bl;
  AiboJoint knee_bl;
  AiboJoint thigh_br;
  AiboJoint knee_br;
  List aiboJoints;
  
  public Aibo3DForward(Scene scene) {
    _scene=scene;
    _namedObjects=scene.getNamedObjects();

    makeSceneTransformable();
    initERS210();
  }

  public List getAiboJoints() {
    return aiboJoints;    
  }

  void makeSceneTransformable() {
    for (Enumeration e=_namedObjects.keys(); e.hasMoreElements();)
      makeObjectTransformable(e.nextElement());
  }

  void makeObjectTransformable(Object key) {
    TransformGroup objtg=getTG(key);
    objtg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
    objtg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
  }

  void printNamedObjects() {
    for (Enumeration e=_namedObjects.keys(); e.hasMoreElements();)
      System.out.println(e.nextElement());
  }

  void printNamedObjectTransformationMatrices() {
    for (Enumeration e=_namedObjects.keys(); e.hasMoreElements();) {
      System.out.println(e.nextElement()+": ");
      printNamedObjectTransformationMatrix(e.nextElement());
    }
  }

  void printNamedObjectTransformationMatrix(Object key) {
    TransformGroup objtg=getTG(key);
    Transform3D t3d=new Transform3D();
    objtg.getTransform(t3d);
    System.out.println(t3d);
  }

  public TransformGroup getTG(Object key) {
    return (TransformGroup)_namedObjects.get(key);
  }

  void initERS210 () {
    neck=new AiboJoint(getTG("objects/neck.lwo"), "neck",
                       -46.0f,   85.0f,
                       0.0f,     0.0f,
                       0.0f,     0.0f);
    head=new AiboJoint(getTG("objects/head.lwo"), "head",
                       0.0f,     0.0f,
                       -92.6f,   92.6f,
                       -32.0f,   32.0f);
    jaw=new AiboJoint(getTG("objects/jaw.lwo"), "jaw",
                       0.0f,     50.0f,
                       0.0f,     0.0f,
                       0.0f,     0.0f);
    tail=new AiboJoint(getTG("objects/tail2.lwo"), "tail",
                       -25.0f,   25.0f,
                       -25.0f,   25.0f,
                       0.0f,     0.0f);
    thigh_fl=new AiboJoint(getTG("objects/leg-f-up-l.lwo"), "thigh_fl",
                       -120.0f,  120.0f,
                       0.0f,     0.0f,
                       -15.0f,   92.0f);
    thigh_fr=new AiboJoint(getTG("objects/leg-f-up-r.lwo"), "thigh_fr",
                       -120.0f,  120.0f,
                       0.0f,     0.0f,
                       -92.0f,   15.0f);
    thigh_bl=new AiboJoint(getTG("objects/leg-b-up-l.lwo"), "thigh_bl",
                       -120.0f,  120.0f,
                       0.0f,     0.0f,
                       -15.0f,   92.0f);
    thigh_br=new AiboJoint(getTG("objects/leg-b-up-r.lwo"), "thigh_br",
                       -120.0f,  120.0f,
                       0.0f,     0.0f,
                       -92.0f,   15.0f);
    knee_fl=new AiboJoint(getTG("objects/leg-f-low-l.lwo"), "knee_fl",
                       -115.0f,  65.0f,
                       0.0f,     0.0f,
                       0.0f,     0.0f);
    knee_fr=new AiboJoint(getTG("objects/leg-f-low-r.lwo"), "knee_fr",
                       -115.0f,  65.0f,
                       0.0f,     0.0f,
                       0.0f,     0.0f);
    knee_bl=new AiboJoint(getTG("objects/leg-b-low-l.lwo"), "knee_bl",
                       -65.0f,   115.0f,
                       0.0f,     0.0f,
                       0.0f,     0.0f);
    knee_br=new AiboJoint(getTG("objects/leg-b-low-r.lwo"), "knee_br",
                       -65.0f,   115.0f,
                       0.0f,     0.0f,
                       0.0f,     0.0f);
    aiboJoints=new ArrayList(20);

    aiboJoints.add(head);
    aiboJoints.add(neck);
    aiboJoints.add(jaw);
    aiboJoints.add(tail);
    aiboJoints.add(thigh_fl);
    aiboJoints.add(knee_fl);
    aiboJoints.add(thigh_fr);
    aiboJoints.add(knee_fr);
    aiboJoints.add(thigh_bl);
    aiboJoints.add(knee_bl);
    aiboJoints.add(thigh_br);
    aiboJoints.add(knee_br);
  }
}
