import java.awt.*;
import java.awt.event.*;
import javax.media.j3d.*;
import java.io.*;
import javax.vecmath.*;
import java.util.*;
import java.lang.*;

import com.sun.j3d.loaders.lw3d.Lw3dLoader;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.behaviors.mouse.*;
import com.sun.j3d.utils.picking.behaviors.*;
import com.sun.j3d.utils.picking.*;

public class Aibo3D extends Frame {
  public static void main(String args[]) {
		if(args.length<1) {
			System.out.println("Usage: java Aibo3D host [port]");
			System.out.println("       if port is not specified, it defaults to 10031");
			System.exit(2);
		}
		int port=10031;
		if(args.length>1)
			port=Integer.parseInt(args[1]);
    new Aibo3D(args[0],port);
  }

  public Aibo3D(String host, int port) {
    super("Aibo 3D");
    setSize(600,400);

    setup3DCanvas();
    loadLW3D("aibo3d.lws");
    forward=new Aibo3DForward(scene);
    showScene();
  
    wsj=new WorldStateJointsListener(host,port);
    while (true) {
      if (wsj.isConnected()) {
        if (wsj.hasData()) {
          Joints j=wsj.getData();
          float[] p=j.positions;
          forward.knee_fl.setX(-p[2]);
          forward.thigh_fl.set(-p[0],0.0f,p[1]);
          forward.knee_fr.setX(-p[5]);
          forward.thigh_fr.set(-p[3],0.0f,-p[4]);
          forward.knee_bl.setX(p[8]);
          forward.thigh_bl.set(p[6],0.0f,p[7]);
          forward.knee_br.setX(p[11]);
          forward.thigh_br.set(p[9],0.0f,-p[10]);
          forward.neck.setX(-p[12]);
          forward.head.set(0.0f,p[13],p[14]);
          forward.tail.set(p[15],p[16],0.0f);
          forward.jaw.setX(-p[17]);
        }
      }
      sleep(10);
    }
  
//    testLimits(forward.thigh_bl,50);
  }

  void testLimits(AiboJoint j) {
    float step;
    step=(j.maxX-j.minX)/100;
    for (float x=j.minX; x<j.maxX; x+=step) { j.setX(x); sleep(10); }
    for (float x=j.maxX; x>j.minX; x-=step) { j.setX(x); sleep(10); }
    j.setX(0.0f);
    step=(j.maxY-j.minY)/100;
    for (float y=j.minY; y<j.maxY; y+=step) { j.setY(y); sleep(10); }
    for (float y=j.maxY; y>j.minY; y-=step) { j.setY(y); sleep(10); }
    j.setY(0.0f);
    step=(j.maxZ-j.minZ)/100;
    for (float z=j.minZ; z<j.maxZ; z+=step) { j.setZ(z); sleep(10); }
    for (float z=j.maxZ; z>j.minZ; z-=step) { j.setZ(z); sleep(10); }
    j.setZ(0.0f);
  }

  void testLimits(AiboJoint j, int n) {
    for (int i=0; i<n; i++) {
      testLimits(j);
    }
  }

  void sleep(long ms) {
    try { Thread.sleep(ms); } catch (Exception e) {}
  }

  void loadLW3D(String filename) {
    Loader loader=new Lw3dLoader(Loader.LOAD_ALL);
    try {
      scene=loader.load(filename);
    } catch (Exception ex) {
      System.out.println("error loading "+filename);
      System.exit(1);
    }
  }

  void setup3DCanvas() {
    canvas3d=new Canvas3D(SimpleUniverse.getPreferredConfiguration());
    add("Center",canvas3d);
    setVisible(true);
    addWindowListener(new WindowAdapter()         // cleans up properly
      { public void windowClosing(WindowEvent e)
          { dispose(); System.exit(0); } });
  }

  Scene scene=null;
  Canvas3D canvas3d=null;
  Aibo3DForward forward=null;
  WorldStateJointsListener wsj=null;

  void showScene() {
    GraphicsConfiguration config =
      SimpleUniverse.getPreferredConfiguration();


    SimpleUniverse universe = new SimpleUniverse(canvas3d);
    universe.getViewingPlatform().setNominalViewingTransform();

    BranchGroup bg = createSceneGraph(scene);
    universe.addBranchGraph(bg);
  }

  BranchGroup createSceneGraph(Scene scene) {
    BranchGroup root = new BranchGroup();

    TransformGroup trans = new TransformGroup();
    trans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
    trans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);

    BoundingSphere bounds = new BoundingSphere(new Point3d(), 100.0);

    MouseRotate rotator = new MouseRotate(trans);
    rotator.setSchedulingBounds(bounds);
    root.addChild(rotator);

    MouseTranslate translator = new MouseTranslate(trans);
    translator.setSchedulingBounds(bounds);
    root.addChild(translator);

    MouseZoom zoomer = new MouseZoom(trans);
    zoomer.setSchedulingBounds(bounds);
    root.addChild(zoomer); 

    if (scene.getSceneGroup() != null) {
      trans.addChild(scene.getSceneGroup());
      root.addChild(trans);
    }

    return root;
  }
}
