//-*-c++-*-
#ifndef INCLUDED_StartupBehavior_h_
#define INCLUDED_StartupBehavior_h_
#include "Behaviors/BehaviorBase.h"
#include "Motion/MotionManager.h"
#include <vector>

class Controller; // defined in Controller.h, don't actually need header file yet
class ControlBase; // defined in ControlBase.h, don't actually need header file yet

//! This Behavior is the only hardcoded behavior by the framework to start up once all the data structures and such are set up
/*! Similar in idea to the init process in unix/linux. */
class StartupBehavior : public BehaviorBase {
public:
	//! Constructor
	StartupBehavior();
	//! Destructor
	virtual ~StartupBehavior();

	//!Inherited
	//@{
	virtual void DoStart();
	virtual void DoStop();
	virtual void processEvent(const EventBase&);
	virtual std::string getName() const { return "StartupBehavior"; }
	static std::string getClassDescription() { return "The initial behavior, when run, sets up everything else"; }
	//@}
protected:
	//! Initializes the Controller menu structure
	virtual ControlBase* SetupMenus();

	std::vector<BehaviorBase*> spawned; //!< Behaviors spawned from DoStart, so they can automatically be stopped on DoStop
	MotionManager::MC_ID stop_id; //!< the main EmergencyStopMC
	MotionManager::MC_ID pid_id; //!< used to fade in the PIDs up to full strength (from initial zero) This is so the joints don't jerk on startup.
};

extern BehaviorBase& startupBehavior;

#endif
