/*
 * Utility routines for AIBO FastSLAM.
 */

#ifndef _AFS_UTILITY_H_
#define _AFS_UTILITY_H_

#ifdef __cplusplus
extern "C" {
#endif

/* This routine takes the difference between two angles. It assumes that
 * any difference greater than 180 degrees is due to rollover. Input
 * angles should be in the range [0, 2pi). Output angles come in the range
 * [-pi, pi]. */
double find_dtheta(double th1, double th2);

/* Generates normally-distributed random numbers with the Box-Muller
 * transform. See http://www.taygeta.com/random/gaussian.html */
double normRand();

#ifdef __cplusplus
}
#endif
#endif

