#ifndef INCLUDED_VisionSerializer_h
#define INCLUDED_VisionSerializer_h

#include "Vision.h"
#include "VisionInterface.h"
#include "Shared/Serializer.h"

//! Encodes and transmits camera images
class VisionSerializer : public Serializer {
public:
  VisionSerializer(); //!< constructor
  void serialize();   //!< encodes and sends current frame
  
private:
	//! encodes the original camera image
  void encodeVisionRaw(char *buf,CMVision::image_yuv<const uchar> &img,
                       int scale);
	//! encodes the RLE processed image
  void encodeVisionRLE(char *buf,int num_runs,run *runs);
	//! helper function for encodeVisionRLE, encodes one run length
  inline char* encodeVisionRun(char *buf, run *run);

  VisionSerializer(const VisionSerializer&);              //!< don't call
  VisionSerializer& operator= (const VisionSerializer&);  //!< don't call

  Socket *visRaw;  //!< socket to which raw vision images should be sent
  Socket *visRLE;  //!< socket to which RLE images shoudl be sent
};

/*! @file
 * @brief Describes VisionSerializer, which encodes and transmits camera images
 * @author CMU RoboSoccer 2001-2002 (Creator)
 * @author alokl (Ported)
 * 
 * @verbinclude CMPack_license.txt
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_3 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/06/12 23:41:41 $
 */

#endif
