/*=========================================================================
    CMPack'02 Source Code Release for OPEN-R SDK v1.0
    Copyright (C) 2002 Multirobot Lab [Project Head: Manuela Veloso]
    School of Computer Science, Carnegie Mellon University
  -------------------------------------------------------------------------
    This software is distributed under the GNU General Public License,
    version 2.  If you do not have a copy of this licence, visit
    www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
    Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
    in the hope that it will be useful, but WITHOUT ANY WARRANTY,
    including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -------------------------------------------------------------------------
    Additionally licensed to Sony Corporation under the following terms:

    This software is provided by the copyright holders AS IS and any
    express or implied warranties, including, but not limited to, the
    implied warranties of merchantability and fitness for a particular
    purpose are disclaimed.  In no event shall authors be liable for
    any direct, indirect, incidental, special, exemplary, or consequential
    damages (including, but not limited to, procurement of substitute
    goods or services; loss of use, data, or profits; or business
    interruption) however caused and on any theory of liability, whether
    in contract, strict liability, or tort (including negligence or
    otherwise) arising in any way out of the use of this software, even if
    advised of the possibility of such damage.
  =========================================================================
*/

#include "Vision.h"
#include "VisionSerializer.h"
#include "Wireless/Wireless.h"
#include "Shared/Config.h"
#include "Shared/get_time.h"

VisionSerializer::VisionSerializer() : visRaw(NULL), visRLE(NULL) {
  visRaw=wireless->socket(SocketNS::SOCK_STREAM, 1024, 88*72*3);
  visRLE=wireless->socket(SocketNS::SOCK_STREAM, 1024, 22*144*3*2);
  wireless->listen(visRaw, config->vision.raw_port);
  wireless->listen(visRLE, config->vision.rle_port);
}

void
VisionSerializer::serialize() {
//  static int time=get_time();
//  static int frame=0;
  char *buf=(char*)visRaw->getWriteBuffer(22*144*3);
  if (buf) {
    encodeVisionRaw((char *)buf,vision->img,2); 
    //visRaw->write(174*144*3);
    visRaw->write(88*72*3);
/*    if (get_time()-time>1000) {
      time=get_time();
      cout << frame << "hz " << time << endl;
      frame=0;
    } else {
      frame++;
    }*/
  }

  buf=(char*)visRLE->getWriteBuffer(22*144*3*2);
  if (buf) {
    encodeVisionRLE((char *)buf, vision->num_runs, vision->rmap);
    visRLE->write(4+vision->num_runs*3);
  }
  
}

char *
VisionSerializer::encodeVisionRun(char *buf, run *rn) {
  buf[0]=(uchar)rn->color;
  buf[1]=(uchar)rn->x;
  buf[2]=(uchar)rn->width;
  return buf+3;
}

void
VisionSerializer::encodeVisionRaw(char *buf,
                                  CMVision::image_yuv<const uchar> &img,
                                  int scale) {
  const uchar *row_y,*row_u,*row_v;
  int height, width;
  height = img.height;
  width  = img.width;

  for(int y=0; y<height; y+=scale) {
    row_y = img.buf_y + y*img.row_stride;
    row_u = img.buf_u + y*img.row_stride;
    row_v = img.buf_v + y*img.row_stride;
    for(int x=0; x<width; x+=scale) {
      *(buf  )=row_y[x];
      *(buf+1)=row_u[x];
      *(buf+2)=row_v[x];
      buf+=3;
    }
  }
}

void
VisionSerializer::encodeVisionRLE(char *buf,int num_runs,run *runs) {
  encode(&buf,num_runs);
  for (; num_runs>0; num_runs--, runs++) {
    buf=encodeVisionRun(buf,runs);
  }
};

/*! @file
 * @brief Implements VisionSerializer, which encodes and transmits camera images
 * @author CMU RoboSoccer 2001-2002 (Creator)
 * @author alokl (Ported)
 * 
 * @verbinclude CMPack_license.txt
 *
 * $Author: ejt $
 * $Name: tekkotsu-1_3 $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2003/06/12 23:41:41 $
 */
