#ifndef INCLUDED_debuget_h
#define INCLUDED_debuget_h

#include <stdio.h>

#ifdef DEBUG
#include <iostream>
#include <string.h>
#include <fstream>
//! for historical reasons - the previous compiler give the entire path for __FILE__, for display, just use the filename
inline const char* _extractFilename(const char* path) {
	const char * last=path;
	while(*path++)
		if(*path=='/')
			last=path+1;
	return last;
}
//! if the bool b is false, std::cout the string
#define ASSERT(b,str) {if(!(b)) std::cout << "ASSERT:"<<_extractFilename(__FILE__)<<'.'<<__LINE__<<':'<< str << std::endl;}
//! if the bool b is false, std::cout the string and return
#define ASSERTRET(b,str) {if(!(b)) { std::cout << "ASSERT:"<<_extractFilename(__FILE__)<<'.'<<__LINE__<<':'<< str << std::endl; return; }}
//! if the bool b is false, std::cout the string and return the value
#define ASSERTRETVAL(b,str,v) {if(!(b)) { std::cout << "ASSERT:"<<_extractFilename(__FILE__)<<'.'<<__LINE__<<':'<< str << std::endl; return v; }}
//! if the bool b is false, std::cout the string and exit(x)
#define ASSERTFATAL(b,str,x) {if(!(b)) { std::cout << "ASSERT:"<<_extractFilename(__FILE__)<<'.'<<__LINE__<<':'<< str << std::endl; exit(x); }}
//#define FILELOG(fname,type,str) { ofstream f(fname,type); f<<str; }
#else
//! if the bool b is false, std::cout the string
#define ASSERT(b,str) {}
//! if the bool b is false, std::cout the string and return
#define ASSERTRET(b,str) {}
//! if the bool b is false, std::cout the string and return the value
#define ASSERTRETVAL(b,str,v) {}
//! if the bool b is false, std::cout the string and exit(x)
#define ASSERTFATAL(b,str,x) {}
#endif

//! returns the hex char that corresponds to @a c, which should be 0-16 (returns '.' otherwise)
inline char hexdigit(int c) {
	if(c<0)
		return '.';
	if(c<10)
		return '0'+c;
	if(c<16)
		return 'a'+(c-10);
	return ',';
	}

//! printf's the two hex digits coresponding to a byte
inline void charhexout(char c) {
	printf("%c%c",hexdigit((c>>4)&0x0F),hexdigit(c&0x0F));
}

//! charhexout's @a n bytes starting at @a p
inline void hexout(const void* p, size_t n) {
	printf("%x:\n",reinterpret_cast<unsigned int>(p));
	const char* x=(const char*)p;
	for(unsigned int i=0; i<n;) {
		printf("%6d ",i);
		for(unsigned int k=0; k<8 && i<n; k++) {
			for(unsigned int j=0; j<4 && i<n; j++, i++) {
				charhexout(x[i]);
				//				std::cout << flush;
			}
			printf(" ");
		}
		printf("\n");
	}
}

/*! @file
 * @brief Defines several debugging functions and macros, including ::ASSERT (and variations)
 * @author ejt (Creator)
 *
 * $Author: alokl $
 * $Name: tekkotsu-1_3 $
 * $Revision: 1.1.1.1 $
 * $State: Exp $
 * $Date: 2002/09/30 18:19:48 $
 */

// static void hexout(unsigned int in) {
//   char buf;
//   std::cout << "0x";
//   if (in == 0) std::cout << "0";
//   else {
//     while (in != 0) {
//       if (in % 16 > 9) buf = 'A' + in % 16 - 9;
//       else buf = '0' + in % 16;
//       std::cout << buf;
//       in /= 16;
//     }
//   }
//   std::cout << std::endl;
// }

#endif
